# LINUX  environment specific makefile header
#
# This file is automatically included in platform
# independent makefiles to abstract out features.


# **************************
# Define System dependencies
# **************************

# Define local file extensions
O=.o
A=.a
EXE=
SH=.sh

LIB_DIR=lib/$(PORTDEPS_DIR_NAME)
OBJ_DIR=obj/$(PORTDEPS_DIR_NAME)
XM_TYPE=xm


# ************************************
# Define Project directories 
# ************************************

RDA_INC_DIR=$(OA_ROOT)/inc
RDA_LIB_DIR=$(OA_ROOT)/$(LIB_DIR)
RDA_BIN_DIR=$(OA_ROOT)/bin/$(PORTDEPS_DIR_NAME)
DAMIP_ROOT=$(OA_ROOT)/sdk/damip
RELEASEC_DIR=/usr/home/eworks/ReleaseC/rda

# Basic OpenRDA include path
OPENRDA_INC_PATH=-I$(RDA_INC_DIR) $(LOCAL_INC_PATH)

# ************************************
# Define command symbols
# ************************************
# C compiler command
CC=gcc

# Linker command
LINKER=gcc
LINKER_SHARED=gcc

# library command
AR=ar

# ranlib command
RANLIB=ranlib

# strip command
STRIP=strip

# change directory command
CD=cd

# copy command
CP=cp

# remove command
RM=rm

# touch command
TOUCH=touch

# move command
MV=mv

# make command
MAKE=make

# change group command
CHGRP=chgrp

# rights modifier
CHMOD=chmod

# echo to the terminal
ECHO=echo

# command interpreter
SH_EXE=csh -f

SET_EXE_RIGHTS=$(CHMOD) 755
SET_EXE_GROUP=$(CHGRP) eworks
SET_LIC_RIGHTS=$(CHMOD) 644
SET_LIC_GROUP=$(CHGRP) eworks
SET_SRC_RIGHTS=$(CHMOD) 644
SET_SRC_GROUP=$(CHGRP) eworks
SET_DB_RIGHTS=$(CHMOD) 666
SET_DB_GROUP=$(CHGRP) eworks
SET_SDK_RIGHTS=$(CHMOD) 666
SET_SDK_GROUP=$(CHGRP) eworks

# 
# ************************************
# Define Commands flags 
# ************************************
# Global environment-specific archive A flags
GAFLAGS=cruv

# Global environment-specific archive Y flags
GYFLAGS=-v -d

# Global compile flags
GCFLAGS=  -DLINUX -DLINT_ARGS -O -D_REENTRANT $(NO_UNICODE_FLAGS) -DOA_OS64

# Global ANSI flag setting
GCFLAGS_ANSI=

# Global environment-specific linker L flags
GLFLAGS=

# Global environment-specific linker L flags for shared library
GLFLAGS_SHARED=-Bsymbolic -lc

# Global environment-specific shared library  L flags
GSFLAGS= -shared -export-dynamic

# Global User-defined  DFLAGS
GDFLAGS=$(MAN_DFLAGS)

# System libraries
GSYS_LIBS= -lm -lpthread $(UNICODE_SYS_LIB) -ldl

REC_MAKE_BEG=($(CD)
REC_MAKE_MID=; $(MAKE)
REC_MAKE_END=)

FIND_FILES_ARG={} \;
