#!/bin/sh -f
#!/usr/bin/sh -f


#############################################################
#
# setup.sh  (for OpenRDA ODBC ADK)
#
#############################################################


#############################################################
#
#  Platform specific settings
#
#############################################################

oa_platform=$PLATFORM; export oa_platform
oa_media=none; export oa_media

#some platforms do not support compress allow use of $compress
#        $compress changed to "$compress" below.             JOW/060116
if test "$compress" = ""
then
        compress=compress
fi

if [ $1 = "" ]
then
	echo "maketar.sh {tar filename}"
	exit
fi

oa_tar_file=$1".tar.Z"; export oa_tar_file


#############################################################
#
#  Splash screen
#
#############################################################

echo ""

if test $INSTALL = "odbc" 
then
	echo "Beginning tar of the OpenRDA ODBC ADK"
else
	echo "Beginning tar of the OpenRDA DB Server DDK"
fi

echo "    Platform: $oa_platform"
echo "        File: $oa_tar_file"
echo ""


#############################################################
#
# Create the master list of files to tar
#
#############################################################

echo "	- Creating file list..."

tmpfile=$oa_tar_file".tmp"
rm -f $tmpfile
touch $tmpfile
./file_set.sh $tmpfile list $INSTALL

lstfile=$oa_tar_file".lst"

sed -e "s#^.#./file_set#" $tmpfile > $lstfile

rm -f $tmpfile


#############################################################
#
# Add the installationa files
#
#############################################################

echo "	- Adding installation file list..."

echo "./install/common/cfg_flt.sed" >> $lstfile
echo "./install/common/chkupd.sh" >> $lstfile
echo "./install/common/file_set.sh" >> $lstfile
echo "./install/common/getdir.sh" >> $lstfile
echo "./install/common/main.sh" >> $lstfile
echo "./install/common/cdmap.sh" >> $lstfile
echo "./install/common/maketar2.sh" >> $lstfile
echo "./install/common/oadr_ini.sh" >> $lstfile
echo "./install/common/open_ini.sh" >> $lstfile
echo "./install/common/srvrddk.sh" >> $lstfile
echo "./install/common/srvrinfo.sh" >> $lstfile
echo "./install/$oa_platform/maketar.sh" >> $lstfile
echo "./install/$oa_platform/setup.sh" >> $lstfile

if test $oa_platform = "ssunos5" || test $oa_platform = "phpux" || test $oa_platform = "ilinux" || test $oa_platform = "raix" || test $oa_platform = "aunix"
then
echo "./install/common/odbc_ini.sh" >> $lstfile
fi


#############################################################
#
# tar the needed files
#
#############################################################

echo "	- taring files..."

olddir=`pwd`
cd ../..


if test $oa_platform = "mvs" 
then
 	if test $oa_media != "media" 
	then
		tar -cvfz $oa_tar_file 'cat $lstfile'
	fi
fi

if test $oa_platform = "phpux" 
then
 	if test $oa_media != "media" 
	then
		tar -cvf - `cat $lstfile` | compress -c > $oa_tar_file
	fi
fi

if test $oa_platform = "iscounix" 
then
 	if test $oa_media != "media" 
	then
		tar -cvFf $lstfile - | compress -c > $oa_tar_file
	fi
fi

if test $oa_platform = "ssunos5" 
then
 	if test $oa_media != "media" 
	then
		tar -cvf - -I $lstfile | compress -c > $oa_tar_file
	fi
fi

if test $oa_platform = "raix" 
then
 	if test $oa_media != "media" 
	then
		tar -cvf - `cat $lstfile` | compress -c > $oa_tar_file
	fi
fi

if test $oa_platform = "aunix" 
then
 	if test $oa_media != "media" 
	then
		tar -cvf - -R $lstfile | compress -c > $oa_tar_file
	fi
fi

if test $oa_platform = "ilinux" 
then
 	if test $oa_media != "media" 
	then
		tar -cvf -  -T $lstfile | $compress -c > $oa_tar_file
	fi
fi


cd $olddir
rm -f $lstfile


###########################################################
echo ""
echo "tar successfully completed."
echo ""
###########################################################
