#!/bin/csh

######################################
#
# Setup OPENRDA.INI
#
######################################

 oa_root="$inst_dir"
 oa_openrda_ini="$inst_dir/config/$oa_platform/openrda.ini"

if test $oa_update = "n" 
then
        rm -f $oa_openrda_ini   # remove old one
        touch $oa_openrda_ini

        echo "[COMMON]"                   >> $oa_openrda_ini
        echo "OA_ROOT=$oa_root"           >> $oa_openrda_ini
        echo "SCHEMAPATH=$oa_root/schema" >> $oa_openrda_ini
        echo "CONFIG=$oa_root/config/$oa_platform" >> $oa_openrda_ini
        echo "EncryptionPackage=0"        >> $oa_openrda_ini
        echo "FetchBlock_Size=100"        >> $oa_openrda_ini
        echo "SessPollWaitTime=20"        >> $oa_openrda_ini
        echo "JOINBLOCK_SIZE=10"        >> $oa_openrda_ini
        echo "LogFileClose=1"        >> $oa_openrda_ini
        echo ""                           >> $oa_openrda_ini
        echo "[CLIENT]"                   >> $oa_openrda_ini
        echo "KeyFile=$oa_root/config/$oa_platform/oaclientkey.lic"         >> $oa_openrda_ini
        echo "TraceFile=$oa_root/bin/$oa_platform/oaclient.log" >> $oa_openrda_ini
        echo "PromptForUID=0"             >> $oa_openrda_ini
        echo ""                           >> $oa_openrda_ini
        echo "[TRACECLIENT]"              >> $oa_openrda_ini
        echo "ALL=FATAL|SNO"       >> $oa_openrda_ini
        echo ""                           >> $oa_openrda_ini
        echo "[ODBC32]"                   >> $oa_openrda_ini
        echo "IgnoreUnicodeFunctions=0"             >> $oa_openrda_ini
        echo "TraceFile=$oa_root/bin/$oa_platform/oaodbc.log" >> $oa_openrda_ini
        echo "TraceOptions=0"             >> $oa_openrda_ini

    if test $PLATFORM = "ssunos5" || test $PLATFORM = "ilinux" || test $PLATFORM = "raix" || (test $PLATFORM = "phpux" && test $SUB_PLATFORM = "11")
    then
        echo ""                           >> $oa_openrda_ini
        echo "[JDBC]"                   >> $oa_openrda_ini
        echo "TraceFile=$oa_root/bin/$oa_platform/oajdbc.log" >> $oa_openrda_ini
        echo "TraceOptions=0"             >> $oa_openrda_ini
	fi
fi
