/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.lob;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.lob.CharLobChunk;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkProducer;
import java.io.IOException;
import java.io.Reader;

public class CharLobChunkStream
implements LobChunkProducer {
    Reader reader;
    int chunkSize;
    boolean closed = false;

    public CharLobChunkStream(Reader reader, int chunkSize) {
        this.reader = reader;
        this.chunkSize = chunkSize;
    }

    public LobChunk getNextChunk() throws IOException {
        if (this.closed) {
            throw new IllegalStateException(CommonPlugin.Util.getString("stream_closed"));
        }
        char[] cbuf = new char[this.chunkSize];
        int read = this.reader.read(cbuf);
        if (read > 0 && read < this.chunkSize) {
            char[] buf = new char[read];
            System.arraycopy(cbuf, 0, buf, 0, read);
            cbuf = buf;
        } else if (read == -1) {
            return new CharLobChunk(new char[0], true);
        }
        return new CharLobChunk(cbuf, false);
    }

    public void close() throws IOException {
        this.closed = true;
        this.reader.close();
    }
}

