/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.BatchFetcher;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import java.sql.SQLException;
import java.util.List;

public class BatchResults {
    private Batch currentBatch;
    private Batch previousBatch;
    private Batch nextBatch;
    private int currentRowNumber;
    private int currentRowIndex = -1;
    private int lastRowNumber = -1;
    private BatchFetcher batchFetcher;
    private boolean isWaitingForBatch;
    private int fetchSize;
    private Logger logger;
    private SQLException exception;
    static /* synthetic */ Class class$com$metamatrix$jdbc$BatchResults;

    public static BatchResults newInstance(List[] batch, int beginRow, int endRow, boolean isLast, int fetchSize) {
        if (AOP.useproxy()) {
            Class<?> clazz = class$com$metamatrix$jdbc$BatchResults;
            if (clazz == null) {
                clazz = class$com$metamatrix$jdbc$BatchResults = new BatchResults[0].getClass().getComponentType();
            }
            BatchResults obj = (BatchResults)ProxyFactory.extend(clazz, new Class[]{batch.getClass(), Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE}, new Object[]{batch, new Integer(beginRow), new Integer(endRow), new Boolean(isLast), new Integer(fetchSize)});
            return obj;
        }
        return new BatchResults(batch, beginRow, endRow, isLast, fetchSize);
    }

    public BatchResults(List[] batch, int beginRow, int endRow, boolean isLast, int fetchSize) {
        this.currentBatch = new Batch(batch, beginRow, endRow, isLast);
        this.fetchSize = fetchSize;
        if (isLast) {
            this.lastRowNumber = endRow;
        }
    }

    public synchronized List getCurrentRow() throws SQLException {
        this.checkException();
        return this.currentBatch.getRow(this.currentRowIndex);
    }

    public synchronized boolean hasNext() throws SQLException {
        this.checkException();
        if (this.isLastRow() || this.isAfterLastRow()) {
            return false;
        }
        if (this.currentRowIndex < this.currentBatch.getLength() - 1) {
            return true;
        }
        if (this.nextBatch == null) {
            this.requestBatchAndWait(this.currentRowNumber + 1, this.currentRowNumber + this.fetchSize);
        }
        return this.nextBatch.getLength() != 0;
    }

    public synchronized boolean next() throws SQLException {
        this.checkException();
        if (this.isLastRow()) {
            ++this.currentRowNumber;
            ++this.currentRowIndex;
            return false;
        }
        if (this.isAfterLastRow()) {
            return false;
        }
        if (this.currentRowIndex < this.currentBatch.getLength() - 1) {
            ++this.currentRowIndex;
            ++this.currentRowNumber;
            return true;
        }
        if (this.nextBatch == null) {
            this.requestBatchAndWait(this.currentRowNumber + 1, this.currentRowNumber + this.fetchSize);
        }
        if (this.previousBatch == null) {
            this.previousBatch = new Batch();
        }
        this.previousBatch.setBatch(this.currentBatch);
        this.currentBatch.setBatch(this.nextBatch);
        this.nextBatch = null;
        this.currentRowIndex = 0;
        ++this.currentRowNumber;
        if (this.lastRowNumber != -1 && this.lastRowNumber < this.currentRowNumber) {
            return false;
        }
        if (!this.currentBatch.isLast) {
            int nextBegin = this.currentBatch.getEndRange() + 1;
            int nextEnd = nextBegin + this.fetchSize - 1;
            this.requestBatch(nextBegin, nextEnd);
        }
        return true;
    }

    public synchronized boolean hasPrevious() throws SQLException {
        this.checkException();
        return this.currentRowNumber != 0 && this.currentRowNumber != 1;
    }

    public synchronized boolean previous() throws SQLException {
        this.checkException();
        if (this.currentRowNumber == 0) {
            return false;
        }
        if (this.currentRowNumber == 1) {
            --this.currentRowIndex;
            --this.currentRowNumber;
            return false;
        }
        if (this.currentRowIndex > 0) {
            --this.currentRowIndex;
            --this.currentRowNumber;
            return true;
        }
        if (this.previousBatch == null) {
            this.requestBatchAndWait(this.currentRowNumber - 1, this.currentRowNumber - this.fetchSize);
        }
        if (this.nextBatch == null) {
            this.nextBatch = new Batch();
        }
        this.nextBatch.setBatch(this.currentBatch);
        this.currentBatch.setBatch(this.previousBatch);
        this.previousBatch = null;
        this.currentRowIndex = this.currentBatch.getLength() - 1;
        --this.currentRowNumber;
        if (!this.currentBatch.isBegin()) {
            this.requestBatch(this.currentBatch.getBeginRange() - 1, this.currentBatch.getBeginRange() - this.fetchSize);
        }
        return true;
    }

    public synchronized void setBatch(int beginRow, int endRow, List[] batch, boolean isLast) {
        if (this.currentBatch == null) {
            if (beginRow != 1 && beginRow != 0) {
                this.exception = new MMSQLException(JDBCPlugin.Util.getString("BatchResults.Invalid_Batch", new Integer(beginRow), new Integer(endRow)));
            }
            this.currentBatch = new Batch(batch, beginRow, endRow, isLast);
        } else if (beginRow == this.currentBatch.getEndRange() + 1) {
            this.nextBatch = new Batch(batch, beginRow, endRow, isLast);
        } else if (endRow == this.currentBatch.getBeginRange() - 1) {
            this.previousBatch = new Batch(batch, beginRow, endRow, isLast);
        }
        if (isLast) {
            this.lastRowNumber = endRow;
        }
        this.isWaitingForBatch = false;
        this.notifyAll();
    }

    public void setBatchFetcher(BatchFetcher batchFetcher) {
        this.batchFetcher = batchFetcher;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public synchronized boolean isFirst() throws SQLException {
        this.checkException();
        return this.currentRowNumber == 1 && this.currentBatch.getLength() > 0;
    }

    public synchronized boolean isLast() throws SQLException {
        this.checkException();
        return this.lastRowNumber != -1 && this.lastRowNumber == this.currentRowNumber && this.currentBatch.getLength() > 0;
    }

    public synchronized boolean absolute(int row) throws SQLException {
        this.checkException();
        if (row == 0) {
            return false;
        }
        if (this.currentRowNumber == row) {
            return true;
        }
        if (this.lastRowNumber == 0) {
            return false;
        }
        if (row == 1) {
            if (this.isWaitingForBatch) {
                this.waitForBatch();
                this.checkException();
            }
            boolean isFirstBatch = this.currentBatch.isBegin();
            this.currentRowIndex = 0;
            this.currentRowNumber = 1;
            if (!isFirstBatch) {
                this.currentBatch = null;
                this.previousBatch = null;
                this.previousBatch = null;
                this.requestBatchAndWait(1, this.fetchSize);
            }
            return true;
        }
        if (row > 0) {
            if (this.currentRowNumber < row) {
                while (this.next()) {
                    if (this.currentRowNumber != row) continue;
                    return true;
                }
            }
            if (this.currentRowNumber > row) {
                while (this.previous()) {
                    if (this.currentRowNumber != row) continue;
                    return true;
                }
            }
        }
        if (row < 0) {
            while (this.next()) {
            }
            while (row < 0) {
                if (!this.previous()) {
                    return false;
                }
                ++row;
            }
            return true;
        }
        return false;
    }

    public synchronized int getCurrentRowNumber() throws SQLException {
        this.checkException();
        if (this.isAfterLastRow()) {
            return 0;
        }
        return this.currentRowNumber;
    }

    public synchronized void setException(SQLException e) {
        this.exception = e;
        this.isWaitingForBatch = false;
        this.notify();
    }

    private void waitForBatch() {
        while (this.isWaitingForBatch) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void requestBatchAndWait(int beginRow, int endRow) throws SQLException {
        if (!this.isWaitingForBatch) {
            this.isWaitingForBatch = true;
            this.batchFetcher.requestBatch(beginRow, endRow);
        }
        this.waitForBatch();
        this.checkException();
    }

    private void requestBatch(int beginRow, int endRow) throws SQLException {
        if (this.isWaitingForBatch) {
            this.waitForBatch();
            this.checkException();
        }
        this.isWaitingForBatch = true;
        this.batchFetcher.requestBatch(beginRow, endRow);
    }

    private void checkException() throws SQLException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private boolean isLastRow() {
        return this.lastRowNumber != -1 && this.lastRowNumber == this.currentRowNumber;
    }

    private boolean isAfterLastRow() {
        return this.lastRowNumber != -1 && this.lastRowNumber < this.currentRowNumber;
    }

    void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    class Batch {
        private List[] batch;
        private int beginRow;
        private int endRow;
        private boolean isLast;

        Batch() {
        }

        Batch(List[] batch, int beginRow, int endRow, boolean isLast) {
            this.batch = batch;
            this.beginRow = beginRow;
            this.endRow = endRow;
            this.isLast = isLast;
        }

        int getLength() {
            return this.batch.length;
        }

        List getRow(int index) {
            if (this.batch.length == 0) {
                return null;
            }
            if (index == -1 || index >= this.batch.length) {
                return null;
            }
            return this.batch[index];
        }

        int getBeginRange() {
            return this.beginRow;
        }

        int getEndRange() {
            return this.endRow;
        }

        void setBatch(Batch batch) {
            this.batch = batch.batch;
            this.beginRow = batch.beginRow;
            this.endRow = batch.endRow;
            this.isLast = batch.isLast;
        }

        boolean isLast() {
            return this.isLast;
        }

        boolean isBegin() {
            return this.beginRow == 1;
        }
    }
}

