/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import com.metamatrix.platform.admin.apiimpl.PermissionMetaBaseNodeImpl;
import com.metamatrix.platform.security.api.AbstractAuthorizationObjectEditor;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationModel;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.AuthorizationPermissionsImpl;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaBasePermissionFactory;
import com.metamatrix.platform.security.api.MetaBaseResource;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MetaBaseAuthorizationObjectEditor
extends AbstractAuthorizationObjectEditor {
    private AuthorizationPermissionFactory permFactory = new MetaBasePermissionFactory();
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$AuthorizationPolicy;
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$AuthorizationPolicyID;

    public MetaBaseAuthorizationObjectEditor(boolean createActions) {
        super(createActions);
    }

    public MetaBaseAuthorizationObjectEditor() {
        this(true);
    }

    public AuthorizationPolicy createAuthorizationPolicy(AuthorizationPolicyID policyID) {
        if (policyID == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0047"));
        }
        Class<?> clazz = class$com$metamatrix$platform$security$api$AuthorizationPolicyID;
        if (clazz == null) {
            clazz = class$com$metamatrix$platform$security$api$AuthorizationPolicyID = new AuthorizationPolicyID[0].getClass().getComponentType();
        }
        AuthorizationPolicyID targetID = (AuthorizationPolicyID)this.verifyTargetClass(policyID, clazz);
        AuthorizationPolicy policy = new AuthorizationPolicy(targetID);
        this.createCreationAction(targetID, policy);
        MetaBaseResource rootResource = new MetaBaseResource("/");
        AuthorizationPermission rootPerm = this.permFactory.create(rootResource, MetaBasePermissionFactory.getRealm(), StandardAuthorizationActions.NONE, null);
        policy = this.addPermission(policy, rootPerm);
        return policy;
    }

    public AuthorizationPolicy cloneAuthorizationPolicy(AuthorizationPolicy sourcePolicy, AuthorizationPolicyID policyID) {
        if (policyID == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0001"));
        }
        if (sourcePolicy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0006"));
        }
        Class<?> clazz = class$com$metamatrix$platform$security$api$AuthorizationPolicyID;
        if (clazz == null) {
            clazz = class$com$metamatrix$platform$security$api$AuthorizationPolicyID = new AuthorizationPolicyID[0].getClass().getComponentType();
        }
        AuthorizationPolicyID targetID = (AuthorizationPolicyID)this.verifyTargetClass(policyID, clazz);
        AuthorizationPolicy newPolicy = new AuthorizationPolicy(targetID);
        Class<?> clazz2 = class$com$metamatrix$platform$security$api$AuthorizationPolicy;
        if (clazz2 == null) {
            clazz2 = class$com$metamatrix$platform$security$api$AuthorizationPolicy = new AuthorizationPolicy[0].getClass().getComponentType();
        }
        AuthorizationPolicy theSourcePolicy = (AuthorizationPolicy)this.verifyTargetClass(sourcePolicy, clazz2);
        this.createCreationAction(targetID, newPolicy);
        newPolicy = this.clonePolicyPrincipals(theSourcePolicy, newPolicy);
        newPolicy = this.clonePolicyPermissions(theSourcePolicy, newPolicy);
        return newPolicy;
    }

    public AuthorizationPolicy clonePolicyPermissions(AuthorizationPolicy sourcePolicy, AuthorizationPolicy targetPolicy) {
        if (targetPolicy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (sourcePolicy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0006"));
        }
        Class<?> clazz = class$com$metamatrix$platform$security$api$AuthorizationPolicy;
        if (clazz == null) {
            clazz = class$com$metamatrix$platform$security$api$AuthorizationPolicy = new AuthorizationPolicy[0].getClass().getComponentType();
        }
        AuthorizationPolicy theSourcePolicy = (AuthorizationPolicy)this.verifyTargetClass(sourcePolicy, clazz);
        Class<?> clazz2 = class$com$metamatrix$platform$security$api$AuthorizationPolicy;
        if (clazz2 == null) {
            clazz2 = class$com$metamatrix$platform$security$api$AuthorizationPolicy = new AuthorizationPolicy[0].getClass().getComponentType();
        }
        AuthorizationPolicy theTargetPolicy = (AuthorizationPolicy)this.verifyTargetClass(targetPolicy, clazz2);
        HashSet<AuthorizationPermission> permissions = new HashSet<AuthorizationPermission>();
        Iterator permItr = theSourcePolicy.iterator();
        while (permItr.hasNext()) {
            AuthorizationPermission newPerm = null;
            AuthorizationPermission sourcePerm = (AuthorizationPermission)permItr.next();
            if (sourcePerm != null) {
                try {
                    newPerm = (AuthorizationPermission)sourcePerm.clone();
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
            }
            if (newPerm == null) continue;
            permissions.add(newPerm);
        }
        theTargetPolicy = this.addAllPermissions(theTargetPolicy, permissions);
        return theTargetPolicy;
    }

    public Collection modifyPermissions(PermissionTreeView treeView, AuthorizationPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0048"));
        }
        HashSet<AuthorizationPermission> permissionsToAdd = new HashSet<AuthorizationPermission>();
        HashSet permissionsToRemove = new HashSet();
        List modifiedNodes = treeView.getModified();
        Iterator modifiedNodeItr = modifiedNodes.iterator();
        HashSet<PermissionMetaBaseNodeImpl> effectedNodes = new HashSet<PermissionMetaBaseNodeImpl>();
        LogManager.logDetail("AUTHORIZATION", "modifyPermissions: Starting...");
        while (modifiedNodeItr.hasNext()) {
            PermissionMetaBaseNodeImpl aModifiedNode = (PermissionMetaBaseNodeImpl)modifiedNodeItr.next();
            LogManager.logDetail("AUTHORIZATION", "modifyPermissions: Effected node: " + aModifiedNode);
            AuthorizationPermission newPerm = null;
            LogManager.logDetail("AUTHORIZATION", "modifyPermissions: Removing old perms.");
            permissionsToRemove.addAll(this.getExistingPermissionsToRemove(aModifiedNode, policy));
            LogManager.logDetail("AUTHORIZATION", "modifyPermissions: Creating MetaBase permission.");
            AuthorizationActions theActions = aModifiedNode.getActions();
            if (!theActions.equals(StandardAuthorizationActions.NONE) || aModifiedNode.getResourceName().equals("/")) {
                String resourceID = aModifiedNode.getResourceName();
                newPerm = this.permFactory.create(resourceID, null, theActions);
                LogManager.logDetail("AUTHORIZATION", "modifyPermissions: Adding new perm: <" + newPerm.getResourceName() + " - " + newPerm.getActions() + ">");
                permissionsToAdd.add(newPerm);
            }
            effectedNodes.add(aModifiedNode);
            aModifiedNode.setModified(false, false);
        }
        policy = this.removePermissions(policy, permissionsToRemove);
        policy = this.addAllPermissions(policy, permissionsToAdd);
        return effectedNodes;
    }

    protected AuthorizationPolicy addAllPermissions(AuthorizationPolicy policy, Set permissions) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (permissions == null || permissions.size() == 0) {
            return policy;
        }
        Class<?> clazz = class$com$metamatrix$platform$security$api$AuthorizationPolicy;
        if (clazz == null) {
            clazz = class$com$metamatrix$platform$security$api$AuthorizationPolicy = new AuthorizationPolicy[0].getClass().getComponentType();
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, clazz);
        Iterator permItr = permissions.iterator();
        while (permItr.hasNext()) {
            AuthorizationPermission perm = (AuthorizationPermission)permItr.next();
            AuthorizationRealm realm = perm.getRealm();
            if (!realm.getRealmName().equals(RolePermissionFactory.getRealmName())) continue;
            return thePolicy;
        }
        AuthorizationPermissionsImpl newPermissions = new AuthorizationPermissionsImpl();
        HashSet<AuthorizationPermission> permissionsToRemove = new HashSet<AuthorizationPermission>();
        Iterator newPermItr = permissions.iterator();
        System.out.println(" *** MetaBaseAuthorizationObjectEditor.addAllPermissions...");
        while (newPermItr.hasNext()) {
            AuthorizationPermission aNewPerm = (AuthorizationPermission)newPermItr.next();
            AuthorizationPermission anOldPerm = thePolicy.findPermissionWithResource(aNewPerm.getResource());
            if (anOldPerm != null) {
                System.out.println(" *** Removing Perm: " + anOldPerm.getResourceName() + " - " + StandardAuthorizationActions.getActionsString(anOldPerm.getActions().getValue()));
                permissionsToRemove.add(anOldPerm);
            }
            System.out.println(" *** Adding Perm: " + aNewPerm.getResourceName() + " - " + StandardAuthorizationActions.getActionsString(aNewPerm.getActions().getValue()));
            newPermissions.add(aNewPerm);
        }
        thePolicy = this.removePermissions(thePolicy, permissionsToRemove);
        this.createAddAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PERMISSIONS, newPermissions);
        thePolicy.addAllPermissions(newPermissions);
        return thePolicy;
    }

    private Set getExistingPermissionsToRemove(PermissionMetaBaseNodeImpl aModifiedNode, AuthorizationPolicy policy) {
        HashSet<AuthorizationPermission> permsToRemove = new HashSet<AuthorizationPermission>();
        String resourceName = aModifiedNode.getResourceName();
        MetaBaseResource theResource = new MetaBaseResource(resourceName);
        LogManager.logDetail("AUTHORIZATION", "getExistingPermissionsToRemove: searching for resource: " + theResource);
        AuthorizationPermission existingPerm = policy.findPermissionWithResource(theResource);
        if (existingPerm != null) {
            if (!aModifiedNode.getActions().equals(existingPerm.getActions())) {
                LogManager.logDetail("AUTHORIZATION", "getExistingPermissionsToRemove: Removing.");
                permsToRemove.add(existingPerm);
            }
            if (existingPerm.resourceIsRecursive()) {
                Collection dependantPerms = policy.getDependantPermissions(theResource);
                permsToRemove.addAll(dependantPerms);
            }
        }
        return permsToRemove;
    }
}

