/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.PermissionCollection;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionInfoImpl
implements ConditionalPermissionInfo,
Serializable {
    private static final long serialVersionUID = 3258130245704825139L;
    PermissionInfo[] perms;
    ConditionInfo[] conds;
    boolean deleted = false;
    private static Class[] twoStringClassArray;
    private static Class[] condClassArray;
    static ConditionalPermissionAdminImpl condAdmin;
    static /* synthetic */ Class class$org$osgi$framework$Bundle;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$osgi$service$condpermadmin$ConditionInfo;

    boolean isDeleted() {
        return this.deleted;
    }

    public ConditionalPermissionInfoImpl(ConditionInfo[] conds, PermissionInfo[] perms) {
        this.conds = conds;
        this.perms = perms;
    }

    public ConditionInfo[] getConditionInfos() {
        if (this.conds == null) {
            return null;
        }
        ConditionInfo[] results = new ConditionInfo[this.conds.length];
        System.arraycopy(this.conds, 0, results, 0, this.conds.length);
        return results;
    }

    int addPermissions(PermissionCollection collection, Class permClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String permClassName = permClass.getName();
        Constructor constructor = permClass.getConstructor(twoStringClassArray);
        int count = 0;
        for (int i = 0; i < this.perms.length; ++i) {
            if (!this.perms[i].getType().equals(permClassName)) continue;
            ++count;
            Object[] args = new String[]{this.perms[i].getName(), this.perms[i].getActions()};
            collection.add((Permission)constructor.newInstance(args));
        }
        return count;
    }

    Condition[] getConditions(Bundle bundle) {
        Condition[] conditions = new Condition[this.conds.length];
        for (int i = 0; i < this.conds.length; ++i) {
            Class<?> clazz;
            try {
                clazz = Class.forName(this.conds[i].getType());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            Constructor<?> constructor = null;
            Method method = null;
            try {
                method = clazz.getMethod("getCondition", condClassArray);
                if ((method.getModifiers() & 8) == 0) {
                    method = null;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (method == null) {
                try {
                    constructor = clazz.getConstructor(condClassArray);
                }
                catch (NoSuchMethodException e) {
                    conditions[i] = Condition.FALSE;
                    continue;
                }
            }
            Object[] args = new Object[]{bundle, this.conds[i]};
            try {
                if (method != null) {
                    conditions[i] = (Condition)method.invoke(null, args);
                    continue;
                }
                conditions[i] = (Condition)constructor.newInstance(args);
                continue;
            }
            catch (Throwable t) {
                conditions[i] = Condition.FALSE;
            }
        }
        return conditions;
    }

    public PermissionInfo[] getPermissionInfos() {
        if (this.perms == null) {
            return null;
        }
        PermissionInfo[] results = new PermissionInfo[this.perms.length];
        System.arraycopy(this.perms, 0, results, 0, this.perms.length);
        return results;
    }

    public void delete() {
        this.deleted = true;
        condAdmin.deleteConditionalPermissionInfo(this);
    }

    static void setConditionalPermissionAdminImpl(ConditionalPermissionAdminImpl condAdmin) {
        ConditionalPermissionInfoImpl.condAdmin = condAdmin;
    }

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class[] classArray = new Class[2];
        Class clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            clazz3 = classArray[0] = (class$java$lang$String = new String[0].getClass().getComponentType());
        }
        if ((clazz2 = class$java$lang$String) == null) {
            clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        classArray[1] = clazz2;
        twoStringClassArray = classArray;
        Class[] classArray2 = new Class[2];
        Class clazz4 = class$org$osgi$framework$Bundle;
        if (clazz4 == null) {
            clazz4 = classArray2[0] = (class$org$osgi$framework$Bundle = new Bundle[0].getClass().getComponentType());
        }
        if ((clazz = class$org$osgi$service$condpermadmin$ConditionInfo) == null) {
            clazz = class$org$osgi$service$condpermadmin$ConditionInfo = new ConditionInfo[0].getClass().getComponentType();
        }
        classArray2[1] = clazz;
        condClassArray = classArray2;
    }
}

