/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ConversionException;
import com.sap.conn.jco.JCoAbapObject;
import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.XMLParserException;
import com.sap.conn.jco.rt.AbapClassExceptionInfo;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultAbapObject;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.jco.util.ObjectList;
import com.sap.conn.jco.util.Utf8ByteToCharConverter;
import com.sap.conn.rfc.api.BasXMLAware;
import com.sap.conn.rfc.api.IRfcTable;
import com.sap.conn.rfc.engine.Trc;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class BasXMLParser {
    private static final int READ_BUFFER_SIZE = 16384;
    private static final int PARAMETER_LEVEL = 2;
    private static final int SCALAR_PARAMETER_LEVEL = 3;
    private static final int PARENT_CLASS_LEVEL = 3;
    private static final int OBJECT_CONTENT_LEVEL = 4;
    private static final String LINES = "lines";
    private static final String HREF = "href";
    private static final String ID = "id";
    byte[] buffer;
    FastStringBuffer tagBuffer;
    byte[] valueBuffer;
    int valueBufferContent;
    int valueBeginIndex;
    int valueLength;
    char[] fieldDataBuffer;
    int fieldDataContent;
    int fieldIndex;
    String fieldName;
    State currentState;
    State returnState;
    State backupState;
    int hierarchyLevel;
    int readPosition;
    int maxFilledPosition;
    int[] tableNestLevels;
    int currentTableNestLevelIndex;
    int remainingValueLength = 0;
    int remainingBuffer = 0;
    int discardContentLevel;
    HashMap<String, BasXMLAware> parameterRecords;
    IRfcTable[] tables;
    ObjectList<AbstractRecord> recordStack;
    AbstractRecord currentRecord;
    Utf8ByteToCharConverter byteToCharConverter;
    Inflater inflater;
    ObjectList<String> idStringList;
    String version;
    String encoding;
    String parameterName = null;
    String attributeName = null;
    int numBytes;
    boolean trace;
    boolean expectRowTag;
    boolean closedNestedRowTag;
    Mode parserMode;
    HashMap<String, AbstractRecord> heapObjects;
    HashMap<String, ArrayList<Reference>> references;
    String exceptionObjectReference;
    AbapClassExceptionInfo exceptionInfo;
    String exceptionName;
    JCoRepository repository;
    private static DefaultClassMetaData classCX_ROOT = new DefaultClassMetaData("CX_ROOT", null, new String[]{"IF_MESSAGE", "IF_SERIALIZABLE_OBJECT"}, 4);
    private static DefaultClassMetaData classCX_REMOTE_UNKNOWN_EXCEPTION = new DefaultClassMetaData("CX_REMOTE_UNKNOWN_EXCEPTION", new String[]{"CX_ROOT", "CX_DYNAMIC_CHECK", "CX_REMOTE_EXCEPTION", "CX_REMOTE_UNSPECIFIED_EXC"}, new String[]{"IF_MESSAGE", "IF_SERIALIZABLE_OBJECT"}, 6);

    public BasXMLParser(HashMap<String, BasXMLAware> parameterRecords, IRfcTable[] tables, boolean trace, boolean compressed) {
        this(trace, compressed);
        this.parameterRecords = parameterRecords;
        this.tables = tables;
        this.parserMode = Mode.FUNCTION;
    }

    public BasXMLParser(boolean trace, boolean compressed, JCoRepository repository) {
        this(trace, compressed);
        this.heapObjects = new HashMap(11);
        this.references = new HashMap(11);
        this.repository = repository;
        this.parserMode = Mode.EXCEPTION;
    }

    private BasXMLParser(boolean trace, boolean compressed) {
        this.trace = trace;
        this.expectRowTag = false;
        this.closedNestedRowTag = false;
        this.buffer = new byte[16384];
        this.tagBuffer = new FastStringBuffer(32);
        this.valueBuffer = new byte[128];
        this.fieldDataBuffer = new char[128];
        this.fieldDataContent = 0;
        this.valueBufferContent = 0;
        this.currentState = State.INITIAL;
        this.returnState = State.INITIAL;
        this.hierarchyLevel = 0;
        this.readPosition = 0;
        this.valueBeginIndex = -1;
        this.valueLength = -1;
        this.recordStack = new ObjectList(16);
        this.currentRecord = null;
        this.idStringList = new ObjectList(32);
        this.idStringList.add("");
        this.idStringList.add("");
        this.tableNestLevels = new int[16];
        this.currentTableNestLevelIndex = 0;
        this.byteToCharConverter = new Utf8ByteToCharConverter();
        this.inflater = compressed ? new Inflater(true) : null;
    }

    public void parse() throws XMLParserException {
        while (this.readPosition < this.maxFilledPosition) {
            block1 : switch (this.currentState) {
                case INITIAL: {
                    switch (this.buffer[this.readPosition]) {
                        case 66: {
                            this.currentState = State.VERSION;
                            if (this.buffer[++this.readPosition] != 88 || this.buffer[++this.readPosition] != 77 || this.buffer[++this.readPosition] != 76) break;
                            ++this.readPosition;
                            break block1;
                        }
                    }
                    try {
                        throw new XMLParserException("A BXML document needs to begin with the magic header 'BXML' instead of '" + (char)this.buffer[this.readPosition] + "', in \"" + new String(this.buffer, Math.max(0, this.readPosition - 10), Math.min(10, this.readPosition) + Math.min(this.maxFilledPosition - this.readPosition, 10), "utf-8") + '\"');
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        break;
                    }
                }
                case VERSION: {
                    switch (this.buffer[this.readPosition]) {
                        case 63: {
                            this.currentState = State.ENCODING;
                            if (this.buffer[++this.readPosition] != 3 || this.buffer[++this.readPosition] != 86 || this.buffer[++this.readPosition] != 69 || this.buffer[++this.readPosition] != 82) break;
                            ++this.readPosition;
                            this.readVersion();
                            break block1;
                        }
                    }
                    throw new XMLParserException("A BXML document needs to contain the version information in the beginning");
                }
                case ENCODING: {
                    switch (this.buffer[this.readPosition]) {
                        case 63: {
                            this.currentState = State.ENVELOPE;
                            this.returnState = State.ENVELOPE;
                            if (this.buffer[++this.readPosition] != 3 || this.buffer[++this.readPosition] != 69 || this.buffer[++this.readPosition] != 78 || this.buffer[++this.readPosition] != 67) break;
                            ++this.readPosition;
                            this.readEncoding();
                            break block1;
                        }
                    }
                    throw new XMLParserException("A BXML document needs to contain the encoding information in the beginning");
                }
                case ENVELOPE: {
                    switch (this.buffer[this.readPosition]) {
                        case 43: {
                            ++this.readPosition;
                            this.currentState = State.STRINGID;
                            this.readValue();
                            break block1;
                        }
                        case 58: {
                            this.defineNamespace();
                            break block1;
                        }
                        case 42: {
                            this.enforceNamespace();
                            break block1;
                        }
                        case 64: {
                            ++this.readPosition;
                            this.currentState = State.ATTRIBUTE;
                            this.readToken();
                            break block1;
                        }
                        case 60: {
                            ++this.readPosition;
                            this.currentState = State.TAG;
                            this.readToken();
                            if ("values".equals(this.fieldName)) {
                                this.currentState = State.PARAMETER;
                                this.returnState = State.PARAMETER;
                                break block1;
                            }
                            if (!"heap".equals(this.fieldName)) break block1;
                            this.currentState = State.HEAP;
                            this.returnState = State.HEAP;
                            this.parserMode = Mode.HEAP;
                            break block1;
                        }
                        case 62: {
                            ++this.readPosition;
                            this.processEndTag();
                            break block1;
                        }
                        case 65: {
                            ++this.readPosition;
                            this.currentState = State.ATTRIBUTE_TEXT;
                            this.readValue();
                            break block1;
                        }
                    }
                    throw new XMLParserException("Unexpected token in the envelope of the current BXML document: '" + (char)this.buffer[this.readPosition] + "'");
                }
                case HEAP: {
                    switch (this.buffer[this.readPosition]) {
                        case 43: {
                            ++this.readPosition;
                            this.currentState = State.STRINGID;
                            this.remainingValueLength = -1;
                            this.readValue();
                            break block1;
                        }
                        case 91: {
                            ++this.readPosition;
                            this.currentState = State.TAG_PURE;
                            this.remainingValueLength = -1;
                            this.readToken();
                            break block1;
                        }
                        case 60: {
                            ++this.readPosition;
                            this.currentState = State.TAG;
                            this.remainingValueLength = -1;
                            this.readToken();
                            break block1;
                        }
                        case 62: {
                            ++this.readPosition;
                            this.processEndTag();
                            break block1;
                        }
                        case 84: {
                            ++this.readPosition;
                            this.currentState = State.TEXT;
                            this.remainingValueLength = -1;
                            this.readValue();
                            break block1;
                        }
                        case 66: {
                            ++this.readPosition;
                            this.currentState = State.BINARY;
                            this.remainingValueLength = -1;
                            this.readValue();
                            break block1;
                        }
                        case 65: {
                            ++this.readPosition;
                            this.currentState = State.ATTRIBUTE_TEXT;
                            this.readValue();
                            break block1;
                        }
                        case 64: {
                            ++this.readPosition;
                            this.currentState = State.ATTRIBUTE;
                            this.readToken();
                            break block1;
                        }
                        case 58: {
                            this.defineNamespace();
                            break block1;
                        }
                        case 42: {
                            this.enforceNamespace();
                            break block1;
                        }
                    }
                    throw new XMLParserException("Unexpected token " + (this.parameterName == null ? " while processing serialized heap" : "in object " + this.parameterName + " in the serialized heap") + " of the current BXML document: '" + (char)this.buffer[this.readPosition] + "' at position " + this.readPosition);
                }
                case DISCARD_PARAMETER: 
                case PARAMETER: {
                    switch (this.buffer[this.readPosition]) {
                        case 43: {
                            ++this.readPosition;
                            this.currentState = State.STRINGID;
                            this.remainingValueLength = -1;
                            this.readValue();
                            break block1;
                        }
                        case 91: {
                            ++this.readPosition;
                            this.currentState = State.TAG_PURE;
                            this.remainingValueLength = -1;
                            this.readToken();
                            break block1;
                        }
                        case 60: {
                            ++this.readPosition;
                            this.currentState = State.TAG;
                            this.remainingValueLength = -1;
                            this.readToken();
                            break block1;
                        }
                        case 62: {
                            ++this.readPosition;
                            this.processEndTag();
                            break block1;
                        }
                        case 84: {
                            ++this.readPosition;
                            this.currentState = State.TEXT;
                            this.remainingValueLength = -1;
                            this.readValue();
                            break block1;
                        }
                        case 66: {
                            ++this.readPosition;
                            this.currentState = State.BINARY;
                            this.remainingValueLength = -1;
                            this.readValue();
                            break block1;
                        }
                        case 65: {
                            ++this.readPosition;
                            this.currentState = State.ATTRIBUTE_TEXT;
                            this.readValue();
                            break block1;
                        }
                        case 64: {
                            ++this.readPosition;
                            this.currentState = State.ATTRIBUTE;
                            this.readToken();
                            break block1;
                        }
                    }
                    throw new XMLParserException("Unexpected token " + (this.parameterName == null ? " while processing parameters" : "in parameter " + this.parameterName) + " of the current BXML document: '" + (char)this.buffer[this.readPosition] + "' at position " + this.readPosition);
                }
                case PROCESS_CONTENT: {
                    switch (this.buffer[this.readPosition]) {
                        case 43: {
                            ++this.readPosition;
                            this.currentState = State.STRINGID;
                            this.remainingValueLength = -1;
                            this.readValue();
                            break block1;
                        }
                        case 91: {
                            ++this.readPosition;
                            this.currentState = State.TAG_PURE;
                            this.remainingValueLength = -1;
                            this.readToken();
                            break block1;
                        }
                        case 60: {
                            ++this.readPosition;
                            this.currentState = State.TAG;
                            this.remainingValueLength = -1;
                            this.readToken();
                            break block1;
                        }
                        case 62: {
                            ++this.readPosition;
                            this.processEndTag();
                            break block1;
                        }
                        case 84: {
                            ++this.readPosition;
                            this.currentState = State.TEXT;
                            this.remainingValueLength = -1;
                            this.readValue();
                            break block1;
                        }
                        case 66: {
                            ++this.readPosition;
                            this.currentState = State.BINARY;
                            this.remainingValueLength = -1;
                            this.readValue();
                            break block1;
                        }
                        case 65: {
                            ++this.readPosition;
                            this.currentState = State.ATTRIBUTE_TEXT;
                            this.readValue();
                            break block1;
                        }
                        case 64: {
                            ++this.readPosition;
                            this.currentState = State.ATTRIBUTE;
                            this.readToken();
                            break block1;
                        }
                    }
                    throw new XMLParserException("Unexpected token while processing " + this.fieldName + (this.parameterName == null ? " in parameters content" : "in content of parameter " + this.parameterName) + " of the current BXML document: '" + (char)this.buffer[this.readPosition] + "' at position " + this.readPosition);
                }
                case PROCESS_CONTENT_DISCARDING: {
                    switch (this.buffer[this.readPosition]) {
                        case 43: {
                            ++this.readPosition;
                            this.currentState = State.STRINGID;
                            this.returnState = State.PROCESS_CONTENT_DISCARDING;
                            this.remainingValueLength = -1;
                            this.readValue();
                            break block1;
                        }
                        case 91: {
                            ++this.readPosition;
                            this.currentState = State.TAG_PURE;
                            this.returnState = State.PROCESS_CONTENT_DISCARDING;
                            this.remainingValueLength = -1;
                            this.readToken();
                            break block1;
                        }
                        case 60: {
                            ++this.readPosition;
                            this.currentState = State.TAG;
                            this.returnState = State.PROCESS_CONTENT_DISCARDING;
                            this.remainingValueLength = -1;
                            this.readToken();
                            break block1;
                        }
                        case 64: {
                            ++this.readPosition;
                            this.currentState = State.ATTRIBUTE;
                            this.readToken();
                        }
                        case 62: {
                            ++this.readPosition;
                            this.processEndTag();
                            break block1;
                        }
                        case 65: 
                        case 66: 
                        case 84: {
                            ++this.readPosition;
                            this.currentState = State.DISCARD_VALUE;
                            this.remainingValueLength = -1;
                            this.readValue();
                            break block1;
                        }
                    }
                    throw new XMLParserException("Unexpected token while discarding " + this.fieldName + (this.parameterName == null ? " in parameters content" : " in content of parameter " + this.parameterName) + " of the current BXML document: '" + (char)this.buffer[this.readPosition] + "' at position " + this.readPosition);
                }
                case TEXT_CHECK_CHUNK: 
                case DISCARD_VALUE_CHECK_CHUNK: {
                    if (this.buffer[this.readPosition] == 84) {
                        ++this.readPosition;
                        if (this.valueBeginIndex >= 0) {
                            if (this.valueLength > this.valueBuffer.length) {
                                this.expandValueBufferCapacity(this.valueLength);
                            }
                            System.arraycopy(this.buffer, this.valueBeginIndex, this.valueBuffer, 0, this.valueLength);
                            this.valueBeginIndex = -1;
                            this.valueBufferContent = this.valueLength;
                        }
                        this.currentState = this.currentState == State.TEXT_CHECK_CHUNK ? State.TEXT_CHUNK : State.DISCARD_VALUE_CHUNK;
                        break;
                    }
                    if (this.valueBeginIndex >= 0) {
                        this.storeValue(this.buffer, this.valueBeginIndex, this.valueLength);
                        this.valueBeginIndex = -1;
                    } else {
                        this.storeValue(this.valueBuffer, 0, this.valueBufferContent);
                    }
                    if (this.hierarchyLevel > 3) {
                        this.currentState = this.currentState == State.TEXT_CHECK_CHUNK ? State.PROCESS_CONTENT : State.PROCESS_CONTENT_DISCARDING;
                        break;
                    }
                    this.currentState = this.returnState;
                    break;
                }
                case TEXT_CHUNK: 
                case DISCARD_VALUE_CHUNK: {
                    this.readChunk();
                    break;
                }
                case TAG: 
                case TAG_PURE: 
                case ATTRIBUTE: {
                    this.readToken();
                    break;
                }
                case DISCARD_VALUE: 
                case TEXT: 
                case ATTRIBUTE_TEXT: 
                case BINARY: 
                case STRINGID: {
                    this.readValue();
                    break;
                }
                case TAG_NAMESPACE: 
                case ATTRIBUTE_NAMESPACE: {
                    this.readNamespace();
                    break;
                }
                case DISCARD_VALUE_RESUMABLE: 
                case TEXT_RESUMABLE: 
                case ATTRIBUTE_TEXT_RESUMABLE: 
                case BINARY_RESUMABLE: 
                case STRINGID_RESUMABLE: {
                    this.resumeValue();
                }
            }
        }
        switch (this.currentState) {
            case TEXT_CHECK_CHUNK: {
                if (this.valueBeginIndex < 0) break;
                if (this.valueLength > this.valueBuffer.length) {
                    this.expandValueBufferCapacity(this.valueLength);
                }
                System.arraycopy(this.buffer, this.valueBeginIndex, this.valueBuffer, 0, this.valueLength);
                this.valueBufferContent = this.valueLength;
                this.valueBeginIndex = -1;
                break;
            }
            case DISCARD_VALUE_CHECK_CHUNK: {
                this.valueBeginIndex = -1;
                break;
            }
        }
    }

    private void readToken() {
        int[] infoName = this.byteToCharConverter.convertToInt(this.buffer, this.readPosition, this.maxFilledPosition - 1);
        if (infoName[0] == -1) {
            this.remainingBuffer = this.byteToCharConverter.getRemainingByteCount();
            System.arraycopy(this.buffer, this.readPosition, this.buffer, 0, this.remainingBuffer);
            this.readPosition = this.maxFilledPosition;
        } else {
            this.readPosition += infoName[1];
            switch (this.currentState) {
                case TAG_PURE: {
                    this.fieldName = this.idStringList.get(infoName[0]);
                    this.processBeginTag();
                    if (this.hierarchyLevel > 3) break;
                    this.currentState = this.returnState;
                    break;
                }
                case TAG: {
                    this.fieldName = this.idStringList.get(infoName[0]);
                    this.processBeginTag();
                    this.backupState = this.currentState;
                    this.currentState = State.TAG_NAMESPACE;
                    this.readNamespace();
                    break;
                }
                case ATTRIBUTE: {
                    this.attributeName = this.idStringList.get(infoName[0]);
                    this.currentState = State.ATTRIBUTE_NAMESPACE;
                    this.readNamespace();
                    break;
                }
                default: {
                    assert (false) : "Invalid state " + (Object)((Object)this.currentState) + " while reading value";
                    break;
                }
            }
        }
    }

    private void readNamespace() {
        int[] infoNamespace = this.byteToCharConverter.convertToInt(this.buffer, this.readPosition, this.maxFilledPosition - 1);
        if (infoNamespace[0] == -1) {
            this.remainingBuffer = this.byteToCharConverter.getRemainingByteCount();
            System.arraycopy(this.buffer, this.readPosition, this.buffer, 0, this.remainingBuffer);
            this.readPosition = this.maxFilledPosition;
        } else {
            this.readPosition += infoNamespace[1];
            this.currentState = this.hierarchyLevel > 3 ? this.backupState : this.returnState;
        }
    }

    private void defineNamespace() {
        ++this.readPosition;
        int[] info = this.byteToCharConverter.convertToInt(this.buffer, this.readPosition, this.maxFilledPosition - 1);
        this.readPosition += info[1];
        info = this.byteToCharConverter.convertToInt(this.buffer, this.readPosition, this.maxFilledPosition - 1);
        this.readPosition += info[1];
    }

    private void enforceNamespace() {
        ++this.readPosition;
        int[] info = this.byteToCharConverter.convertToInt(this.buffer, this.readPosition, this.maxFilledPosition - 1);
        this.readPosition += info[1];
    }

    private void readValue() {
        int[] info = this.byteToCharConverter.convertToInt(this.buffer, this.readPosition, this.maxFilledPosition - 1);
        if (info[0] == -1) {
            this.remainingBuffer = this.byteToCharConverter.getRemainingByteCount();
            System.arraycopy(this.buffer, this.readPosition, this.buffer, 0, this.remainingBuffer);
            this.readPosition = this.maxFilledPosition;
        } else {
            this.readPosition += info[1];
            if (this.readPosition + info[0] <= this.maxFilledPosition) {
                switch (this.currentState) {
                    case TEXT: {
                        this.currentState = State.TEXT_CHECK_CHUNK;
                        this.valueBeginIndex = this.readPosition;
                        this.valueLength = info[0];
                        break;
                    }
                    case DISCARD_VALUE: {
                        this.currentState = State.DISCARD_VALUE_CHECK_CHUNK;
                        this.valueBeginIndex = this.readPosition;
                        this.valueLength = info[0];
                        break;
                    }
                    case BINARY: {
                        this.storeValue(this.buffer, this.readPosition, info[0]);
                        if (this.hierarchyLevel > 3) {
                            this.currentState = State.PROCESS_CONTENT;
                            break;
                        }
                        this.currentState = this.returnState;
                        break;
                    }
                    case ATTRIBUTE_TEXT: {
                        this.processAttribute(this.buffer, this.readPosition, info[0]);
                        this.currentState = this.returnState;
                        break;
                    }
                    case STRINGID: {
                        this.defineString(this.buffer, this.readPosition, info[0]);
                        this.currentState = this.returnState;
                        break;
                    }
                    default: {
                        assert (false) : "Invalid state " + (Object)((Object)this.currentState) + " while reading value";
                        break;
                    }
                }
                this.readPosition += info[0];
            } else {
                switch (this.currentState) {
                    case TEXT: {
                        this.currentState = State.TEXT_RESUMABLE;
                        break;
                    }
                    case BINARY: {
                        this.currentState = State.BINARY_RESUMABLE;
                        break;
                    }
                    case STRINGID: {
                        this.currentState = State.STRINGID_RESUMABLE;
                        break;
                    }
                    case ATTRIBUTE_TEXT: {
                        this.currentState = State.ATTRIBUTE_TEXT_RESUMABLE;
                        break;
                    }
                    case DISCARD_VALUE: {
                        this.currentState = State.DISCARD_VALUE_RESUMABLE;
                        this.valueBufferContent = this.maxFilledPosition - this.readPosition;
                        this.remainingValueLength = info[0] - this.valueBufferContent;
                        this.readPosition = this.maxFilledPosition;
                        return;
                    }
                    default: {
                        assert (false) : "Invalid state " + (Object)((Object)this.currentState) + " while reading incomplete value";
                        break;
                    }
                }
                if (this.valueBuffer.length < info[0]) {
                    this.expandValueBufferCapacity(info[0]);
                }
                this.valueBufferContent = this.maxFilledPosition - this.readPosition;
                this.remainingValueLength = info[0] - this.valueBufferContent;
                if (this.valueBufferContent > 0) {
                    System.arraycopy(this.buffer, this.readPosition, this.valueBuffer, 0, this.valueBufferContent);
                }
                this.readPosition = this.maxFilledPosition;
            }
        }
    }

    private void readChunk() {
        int[] info = this.byteToCharConverter.convertToInt(this.buffer, this.readPosition, this.maxFilledPosition - 1);
        if (info[0] == -1) {
            this.remainingBuffer = this.byteToCharConverter.getRemainingByteCount();
            System.arraycopy(this.buffer, this.readPosition, this.buffer, 0, this.remainingBuffer);
            this.readPosition = this.maxFilledPosition;
        } else {
            this.readPosition += info[1];
            if (this.readPosition + info[0] <= this.maxFilledPosition) {
                switch (this.currentState) {
                    case TEXT_CHUNK: {
                        this.currentState = State.TEXT_CHECK_CHUNK;
                        int newValueBufferContent = this.valueBufferContent + info[0];
                        if (this.valueBuffer.length < newValueBufferContent) {
                            this.expandValueBufferCapacity(newValueBufferContent);
                        }
                        if (info[0] > 0) {
                            System.arraycopy(this.buffer, this.readPosition, this.valueBuffer, this.valueBufferContent, info[0]);
                        }
                        this.valueBufferContent = newValueBufferContent;
                        break;
                    }
                    case DISCARD_VALUE_CHUNK: {
                        this.currentState = State.DISCARD_VALUE_CHECK_CHUNK;
                        this.valueBufferContent += info[0];
                        break;
                    }
                    default: {
                        assert (false) : "Invalid state " + (Object)((Object)this.currentState) + " while reading value";
                        break;
                    }
                }
                this.readPosition += info[0];
            } else {
                switch (this.currentState) {
                    case TEXT_CHUNK: {
                        this.currentState = State.TEXT_RESUMABLE;
                        int newValueBufferContent = this.valueBufferContent + info[0];
                        if (this.valueBuffer.length < newValueBufferContent) {
                            this.expandValueBufferCapacity(newValueBufferContent);
                        }
                        int copyLength = this.maxFilledPosition - this.readPosition;
                        this.remainingValueLength = info[0] - copyLength;
                        if (info[0] > 0) {
                            System.arraycopy(this.buffer, this.readPosition, this.valueBuffer, this.valueBufferContent, copyLength);
                        }
                        this.valueBufferContent += copyLength;
                        break;
                    }
                    case DISCARD_VALUE_CHUNK: {
                        this.currentState = State.DISCARD_VALUE_RESUMABLE;
                        this.valueBufferContent += this.maxFilledPosition - this.readPosition;
                        this.remainingValueLength = info[0] + this.readPosition - this.maxFilledPosition;
                        this.readPosition = this.maxFilledPosition;
                        return;
                    }
                    default: {
                        assert (false) : "Invalid state " + (Object)((Object)this.currentState) + " while reading incomplete value";
                        break;
                    }
                }
                this.readPosition = this.maxFilledPosition;
            }
        }
    }

    private void resumeValue() {
        assert (this.readPosition == 0) : "Incorrect position in the buffer while resuming a value";
        assert (this.valueBuffer.length >= this.valueBufferContent + this.remainingValueLength) : "Value buffer too small for the value to store next";
        if (this.remainingValueLength > this.maxFilledPosition) {
            System.arraycopy(this.buffer, this.readPosition, this.valueBuffer, this.valueBufferContent, this.maxFilledPosition);
            this.valueBufferContent += this.maxFilledPosition;
            this.remainingValueLength -= this.maxFilledPosition;
            this.readPosition = this.maxFilledPosition;
        } else {
            System.arraycopy(this.buffer, this.readPosition, this.valueBuffer, this.valueBufferContent, this.remainingValueLength);
            this.valueBufferContent += this.remainingValueLength;
            this.readPosition += this.remainingValueLength;
            this.remainingValueLength = 0;
            switch (this.currentState) {
                case TEXT_RESUMABLE: {
                    this.currentState = State.TEXT_CHECK_CHUNK;
                    break;
                }
                case DISCARD_VALUE_RESUMABLE: {
                    this.currentState = State.DISCARD_VALUE_CHECK_CHUNK;
                    break;
                }
                case BINARY_RESUMABLE: {
                    this.storeValue(this.valueBuffer, 0, this.valueBufferContent);
                    if (this.hierarchyLevel > 3) {
                        this.currentState = State.PROCESS_CONTENT;
                        break;
                    }
                    this.currentState = this.returnState;
                    break;
                }
                case ATTRIBUTE_TEXT_RESUMABLE: {
                    this.processAttribute(this.valueBuffer, 0, this.valueBufferContent);
                    this.currentState = this.returnState;
                    break;
                }
                case STRINGID_RESUMABLE: {
                    this.defineString(this.valueBuffer, 0, this.valueBufferContent);
                    this.currentState = this.returnState;
                    break;
                }
                default: {
                    assert (false) : "Invalid state " + (Object)((Object)this.currentState) + " while reading a resumed value";
                    break;
                }
            }
        }
    }

    private void defineString(byte[] stringIDBuffer, int offset, int length) {
        try {
            String stringID = new String(stringIDBuffer, offset, length, this.encoding);
            if (stringID.indexOf("_-") >= 0) {
                this.idStringList.add(this.unescape(stringID));
            } else {
                this.idStringList.add(stringID);
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttribute(byte[] attributeBuffer, int offset, int length) {
        block17: {
            try {
                if (LINES.equals(this.attributeName)) {
                    String lineCount = new String(attributeBuffer, offset, length, this.encoding);
                    try {
                        int numRows = Integer.parseInt(lineCount);
                        if (numRows > 0) {
                            ((DefaultTable)this.currentRecord).ensureBufferCapacity(numRows);
                            if (this.trace) {
                                Trc.ab_rfctrc("Receiving " + numRows + " for table " + this.fieldName + '\n');
                            }
                        }
                        break block17;
                    }
                    catch (ClassCastException ex) {
                        throw new XMLParserException("Internal error in parameter " + this.parameterName + ". Not fitting to real structure.", ex);
                    }
                }
                if (HREF.equals(this.attributeName)) {
                    String objectReferenceID = new String(attributeBuffer, offset, length, this.encoding);
                    if (this.hierarchyLevel == 3 && "EXCEPTION".equals(this.parameterName)) {
                        this.exceptionObjectReference = objectReferenceID.substring(1);
                    } else {
                        ArrayList<Reference> existingReferences = this.references.get(objectReferenceID);
                        if (existingReferences == null) {
                            existingReferences = new ArrayList(1);
                            this.references.put(objectReferenceID, existingReferences);
                        }
                        Reference currentReference = new Reference(this.currentRecord, this.fieldIndex);
                        existingReferences.add(currentReference);
                    }
                } else if (ID.equals(this.attributeName)) {
                    String objectReferenceID = new String(attributeBuffer, offset, length, this.encoding);
                    if (this.exceptionName == null && this.exceptionObjectReference.equals(objectReferenceID)) {
                        this.exceptionName = this.parameterName;
                    }
                    this.heapObjects.put(objectReferenceID, this.currentRecord);
                }
            }
            catch (UnsupportedEncodingException e) {
            }
            finally {
                this.attributeName = null;
            }
        }
    }

    private final void expandValueBufferCapacity(int capacity) {
        int newSize = this.valueBuffer.length * 3 / 2;
        while (newSize < capacity) {
            newSize = newSize * 3 / 2;
        }
        byte[] valueBufferNew = new byte[newSize];
        if (this.valueBufferContent > 0) {
            System.arraycopy(this.valueBuffer, 0, valueBufferNew, 0, this.valueBufferContent);
        }
        this.valueBuffer = valueBufferNew;
    }

    private void readVersion() {
        int[] info = this.byteToCharConverter.convertToInt(this.buffer, this.readPosition, this.maxFilledPosition - 1);
        this.readPosition += info[1];
        try {
            this.version = new String(this.buffer, this.readPosition, info[0], "utf-8");
            this.readPosition += info[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void readEncoding() {
        int[] info = this.byteToCharConverter.convertToInt(this.buffer, this.readPosition, this.maxFilledPosition - 1);
        this.readPosition += info[1];
        try {
            this.encoding = new String(this.buffer, this.readPosition, info[0], "utf-8");
            this.readPosition += info[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private String unescape(String escapedTag) throws XMLParserException {
        int i = 0;
        int end = escapedTag.length();
        this.tagBuffer.reset();
        while (i < end) {
            if (escapedTag.charAt(i) == '_') {
                if (escapedTag.charAt(++i) == '-') {
                    if (escapedTag.charAt(++i) == '-') {
                        try {
                            this.tagBuffer.append((char)Codecs.Hex.decode(escapedTag.charAt(i + 1), escapedTag.charAt(i + 2)));
                            i += 3;
                            continue;
                        }
                        catch (Exception e) {
                            throw new XMLParserException("Illegal escape sequence _--" + escapedTag.charAt(i + 1) + escapedTag.charAt(i + 2) + " encountered", e);
                        }
                    }
                    this.tagBuffer.append('/');
                    continue;
                }
                this.tagBuffer.append('_');
                continue;
            }
            this.tagBuffer.append(escapedTag.charAt(i));
            ++i;
        }
        return this.tagBuffer.toString();
    }

    private void storeValue(byte[] dataBuffer, int offset, int length) throws XMLParserException {
        block2 : switch (this.returnState) {
            case ENVELOPE: 
            case DISCARD_PARAMETER: 
            case DISCARD_VALUE: 
            case DISCARD_VALUE_RESUMABLE: {
                break;
            }
            default: {
                switch (this.currentState) {
                    case DISCARD_VALUE_CHECK_CHUNK: 
                    case DISCARD_VALUE_CHUNK: 
                    case DISCARD_VALUE: 
                    case DISCARD_VALUE_RESUMABLE: {
                        break block2;
                    }
                    case BINARY: 
                    case BINARY_RESUMABLE: {
                        if (this.fieldName == null) {
                            throw new XMLParserException("Invalid token sequence: Before storing the next value, a container has to be identified.");
                        }
                        if (this.currentRecord == null) {
                            throw new XMLParserException("Illegal state: no record found in which to store the parsed value for " + this.fieldName);
                        }
                        try {
                            this.currentRecord.encodeBINARY(dataBuffer, offset, length, this.fieldIndex);
                            break block2;
                        }
                        catch (ConversionException ex) {
                            throw new XMLParserException(ex.toString(), ex);
                        }
                    }
                    case TEXT_CHECK_CHUNK: 
                    case TEXT_CHUNK: 
                    case TEXT: 
                    case TEXT_RESUMABLE: {
                        if (this.fieldName == null) {
                            throw new XMLParserException("Invalid token sequence: Before storing the next value, a container has to be identified.");
                        }
                        if (this.parserMode == Mode.EXCEPTION && this.hierarchyLevel == 3 && "EXCEPTION_TEXT".equals(this.fieldName)) {
                            this.convertToDataBuffer(dataBuffer, offset, length);
                            this.exceptionInfo = new AbapClassExceptionInfo(new String(this.fieldDataBuffer, 0, this.fieldDataContent));
                            break block2;
                        }
                        if (this.currentRecord == null) {
                            throw new XMLParserException("Illegal state: no record found in which to store the parsed value for " + this.fieldName);
                        }
                        this.convertToDataBuffer(dataBuffer, offset, length);
                        try {
                            this.currentRecord.encodeGENERIC(this.fieldDataBuffer, 0, this.fieldDataContent, this.fieldIndex);
                            break block2;
                        }
                        catch (ConversionException ex) {
                            throw new XMLParserException(ex.toString(), ex);
                        }
                    }
                }
            }
        }
    }

    private void convertToDataBuffer(byte[] dataBuffer, int offset, int length) {
        int end = offset + length - 1;
        this.fieldDataContent = this.byteToCharConverter.convert(dataBuffer, offset, end, this.fieldDataBuffer, 0, this.fieldDataBuffer.length - 1);
        int remaining = this.byteToCharConverter.getRemainingByteCount();
        if (remaining > 0) {
            char[] newValueBuffer = new char[remaining + this.fieldDataContent];
            System.arraycopy(this.fieldDataBuffer, 0, newValueBuffer, 0, this.fieldDataContent);
            this.fieldDataBuffer = newValueBuffer;
            this.fieldDataContent += this.byteToCharConverter.convert(dataBuffer, end - remaining + 1, end, this.fieldDataBuffer, this.fieldDataContent, this.fieldDataBuffer.length - 1);
        }
    }

    private void processEndTag() {
        switch (this.currentState) {
            case DISCARD_PARAMETER: {
                --this.hierarchyLevel;
                if (this.hierarchyLevel != 2) break;
                this.currentState = this.parserMode == Mode.HEAP ? State.HEAP : State.PARAMETER;
                this.returnState = this.parserMode == Mode.HEAP ? State.HEAP : State.PARAMETER;
                this.parameterName = null;
                this.fieldName = null;
                break;
            }
            case PROCESS_CONTENT_DISCARDING: 
            case DISCARD_VALUE: {
                --this.hierarchyLevel;
                if (this.discardContentLevel < this.hierarchyLevel) break;
                this.currentState = this.parserMode == Mode.HEAP ? State.HEAP : State.PARAMETER;
                this.returnState = this.parserMode == Mode.HEAP ? State.HEAP : State.PARAMETER;
                this.fieldName = null;
                break;
            }
            case ENVELOPE: {
                --this.hierarchyLevel;
                this.fieldName = null;
                break;
            }
            case PROCESS_CONTENT: {
                --this.hierarchyLevel;
                this.currentState = this.returnState;
                this.fieldName = null;
                break;
            }
            case HEAP: {
                if (this.hierarchyLevel == 4) {
                    --this.hierarchyLevel;
                    this.fieldName = null;
                    break;
                }
            }
            default: {
                if (this.hierarchyLevel > 2) {
                    --this.hierarchyLevel;
                    if (this.hierarchyLevel == 2 && this.parserMode == Mode.EXCEPTION) {
                        this.parameterName = null;
                        this.fieldName = null;
                        break;
                    }
                    if (this.currentRecord.recType == 4) {
                        switch (this.tableNestLevels[this.currentTableNestLevelIndex]) {
                            case 0: {
                                if (this.hierarchyLevel != 2) {
                                    --this.currentTableNestLevelIndex;
                                }
                                this.expectRowTag = false;
                                this.closedNestedRowTag = false;
                                this.recordStack.pop();
                                this.currentRecord.row = 0;
                                this.currentRecord = this.recordStack.last();
                                break;
                            }
                            case 1: {
                                if (this.closedNestedRowTag || this.expectRowTag) {
                                    this.recordStack.pop();
                                    this.currentRecord.row = 0;
                                    this.currentRecord = this.recordStack.last();
                                }
                                this.closedNestedRowTag = false;
                                int n = this.currentTableNestLevelIndex;
                                this.tableNestLevels[n] = this.tableNestLevels[n] - 1;
                                this.expectRowTag = true;
                                break;
                            }
                            default: {
                                int n = this.currentTableNestLevelIndex;
                                this.tableNestLevels[n] = this.tableNestLevels[n] - 1;
                                this.expectRowTag = true;
                                if (this.closedNestedRowTag) {
                                    this.recordStack.pop();
                                    this.currentRecord.row = 0;
                                    this.currentRecord = this.recordStack.last();
                                    break;
                                }
                                this.closedNestedRowTag = true;
                            }
                        }
                        this.fieldName = null;
                        break;
                    }
                    this.recordStack.pop();
                    this.currentRecord = this.recordStack.last();
                    this.fieldName = null;
                    if (this.hierarchyLevel != 2) break;
                    this.parameterName = null;
                    break;
                }
                if (this.hierarchyLevel != 2) break;
                --this.hierarchyLevel;
                this.currentState = State.ENVELOPE;
                this.returnState = State.ENVELOPE;
            }
        }
    }

    private void processBeginTag() {
        switch (this.returnState) {
            case ENVELOPE: 
            case DISCARD_PARAMETER: 
            case PROCESS_CONTENT_DISCARDING: {
                ++this.hierarchyLevel;
                this.currentState = this.returnState;
                break;
            }
            case HEAP: {
                if (this.hierarchyLevel == 2) {
                    ++this.hierarchyLevel;
                    this.currentRecord = new DefaultAbapObject(this.getClassMetaData(this.fieldName));
                    if ("CX_REMOTE_UNKNOWN_EXCEPTION".equals(this.currentRecord.getMetaData().getName())) {
                        this.currentRecord.setValue("EXCEPTION_CLASS_NAME", this.fieldName);
                    }
                    this.recordStack.push(this.currentRecord);
                    this.parameterName = this.fieldName;
                    break;
                }
                if (this.hierarchyLevel == 3) {
                    ++this.hierarchyLevel;
                    this.currentState = this.returnState;
                    break;
                }
                this.processDataBeginTag();
                break;
            }
            default: {
                if (this.hierarchyLevel == 2) {
                    if (this.parserMode == Mode.FUNCTION) {
                        BasXMLAware parameter = this.parameterRecords.get(this.fieldName);
                        if (parameter == null) {
                            if (this.trace) {
                                Trc.ab_rfctrc("***Discarding unrequested binary ASXML Parameter: " + this.fieldName + '\n');
                            }
                            this.currentState = State.DISCARD_PARAMETER;
                            this.returnState = State.DISCARD_PARAMETER;
                        } else {
                            AbstractRecord rootRecord = parameter.getParameterRecord();
                            if (rootRecord.recType == 1) {
                                if (this.trace) {
                                    Trc.ab_rfctrc("Receiving binary ASXML Parameter: " + this.fieldName + '\n');
                                }
                                this.fieldIndex = rootRecord.metaData.indexOfField(this.fieldName);
                                this.recordStack.push(rootRecord);
                            } else {
                                if (rootRecord.recType == 4) {
                                    rootRecord.clear();
                                    this.expectRowTag = true;
                                    if (this.tables != null) {
                                        for (int i = 0; i < this.tables.length; ++i) {
                                            if (!this.tables[i].getName().equals(this.fieldName)) continue;
                                            this.tables[i].setActive();
                                            break;
                                        }
                                    }
                                    if (this.trace) {
                                        Trc.ab_rfctrc("Receiving table as binary ASXML Parameter: " + this.fieldName + '\n');
                                    }
                                } else if (this.trace) {
                                    Trc.ab_rfctrc("Receiving structured binary ASXML Parameter: " + this.fieldName + '\n');
                                }
                                this.recordStack.push(rootRecord);
                            }
                            this.currentRecord = rootRecord;
                        }
                        this.parameterName = this.fieldName;
                        this.hierarchyLevel = 3;
                        break;
                    }
                    this.parameterName = this.fieldName;
                    this.hierarchyLevel = 3;
                    break;
                }
                this.processDataBeginTag();
            }
        }
    }

    private void processDataBeginTag() {
        ++this.hierarchyLevel;
        if (this.currentRecord.recType == 4 && this.expectRowTag) {
            DefaultTable table = (DefaultTable)this.currentRecord;
            this.expectRowTag = false;
            this.closedNestedRowTag = false;
            if (this.tableNestLevels[this.currentTableNestLevelIndex] == 0) {
                table.appendRow();
                int n = this.currentTableNestLevelIndex;
                this.tableNestLevels[n] = this.tableNestLevels[n] + 1;
                if (table.metaData.numFields == 1 && table.metaData.name[0].length() == 0) {
                    switch (table.metaData.type[0]) {
                        case 17: {
                            this.currentState = this.returnState;
                            break;
                        }
                        case 99: {
                            DefaultTable nestedTable = table.getTable(0);
                            this.recordStack.push(nestedTable);
                            this.currentRecord = nestedTable;
                            this.currentState = this.returnState;
                            this.expectRowTag = true;
                            break;
                        }
                        default: {
                            this.currentState = State.PROCESS_CONTENT;
                            this.fieldIndex = 0;
                            int n2 = this.currentTableNestLevelIndex;
                            this.tableNestLevels[n2] = this.tableNestLevels[n2] - 1;
                            this.expectRowTag = true;
                            this.closedNestedRowTag = true;
                            break;
                        }
                    }
                } else {
                    this.currentState = this.returnState;
                }
            } else {
                DefaultTable nestedTable;
                try {
                    nestedTable = (DefaultTable)this.currentRecord;
                }
                catch (ClassCastException ex) {
                    throw new XMLParserException("Internal error in parameter " + this.parameterName + ". Not fitting to real structure.", ex);
                }
                nestedTable.appendRow();
                int n = this.currentTableNestLevelIndex;
                this.tableNestLevels[n] = this.tableNestLevels[n] + 1;
                if (nestedTable.metaData.numFields == 1 && nestedTable.metaData.name[0].length() == 0) {
                    switch (nestedTable.metaData.type[0]) {
                        case 17: {
                            this.currentState = this.returnState;
                            break;
                        }
                        case 99: {
                            DefaultTable nestedTable2 = nestedTable.getTable(0);
                            this.recordStack.push(nestedTable2);
                            this.currentRecord = nestedTable2;
                            this.currentState = this.returnState;
                            this.expectRowTag = true;
                            break;
                        }
                        default: {
                            this.currentState = State.PROCESS_CONTENT;
                            this.fieldIndex = 0;
                            int n3 = this.currentTableNestLevelIndex;
                            this.tableNestLevels[n3] = this.tableNestLevels[n3] - 1;
                            this.expectRowTag = true;
                            this.closedNestedRowTag = true;
                            break;
                        }
                    }
                } else {
                    this.currentState = this.returnState;
                }
            }
        } else {
            this.fieldIndex = this.currentRecord.metaData.indexOfField(this.fieldName);
            if (this.fieldIndex < 0) {
                this.currentState = State.PROCESS_CONTENT_DISCARDING;
                this.returnState = State.DISCARD_VALUE;
                this.discardContentLevel = this.hierarchyLevel - 1;
            } else {
                switch (this.currentRecord.metaData.type[this.fieldIndex]) {
                    case 99: {
                        ++this.currentTableNestLevelIndex;
                        if (this.currentTableNestLevelIndex == this.tableNestLevels.length) {
                            int[] newtableNestLevels = new int[this.tableNestLevels.length + 16];
                            System.arraycopy(this.tableNestLevels, 0, newtableNestLevels, 0, this.tableNestLevels.length);
                            this.tableNestLevels = newtableNestLevels;
                        }
                        this.expectRowTag = true;
                    }
                    case 17: {
                        this.currentState = this.returnState;
                        try {
                            this.currentRecord = (AbstractRecord)this.currentRecord.getValue(this.fieldIndex);
                            this.recordStack.push(this.currentRecord);
                            break;
                        }
                        catch (ConversionException ex) {
                            throw new XMLParserException(ex.toString(), ex);
                        }
                    }
                    case 16: {
                        this.currentState = this.returnState;
                        try {
                            DefaultAbapObject objectRecord = this.currentRecord.getAbapObject(this.fieldIndex);
                            if (objectRecord != null) {
                                this.currentRecord = objectRecord;
                            }
                            this.recordStack.push(this.currentRecord);
                            break;
                        }
                        catch (ConversionException ex) {
                            throw new XMLParserException(ex.toString(), ex);
                        }
                    }
                    default: {
                        this.currentState = State.PROCESS_CONTENT;
                    }
                }
            }
        }
    }

    private JCoClassMetaData getClassMetaData(String clazzName) {
        JCoClassMetaData clazzMetaData = null;
        try {
            if (this.repository != null) {
                clazzMetaData = this.repository.getClassMetaData(clazzName);
                if (clazzMetaData == null) {
                    if (this.trace) {
                        Trc.ab_rfctrc("Metadata for class " + clazzName + " not found in repository " + this.repository.getName() + ". Fallback to CX_REMOTE_UNKNOWN_EXCEPTION\n");
                    }
                    clazzMetaData = this.repository.getClassMetaData("CX_REMOTE_UNKNOWN_EXCEPTION");
                }
            } else {
                if (this.trace) {
                    Trc.ab_rfctrc("No repository available, when processing class " + clazzName + ". Fallback to CX_REMOTE_UNKNOWN_EXCEPTION\n");
                }
                clazzMetaData = classCX_REMOTE_UNKNOWN_EXCEPTION;
            }
        }
        catch (JCoException je) {
            if (this.trace) {
                Trc.ab_rfctrc("Problems while looking up class " + clazzName + ". Fallback to CX_REMOTE_UNKNOWN_EXCEPTION\n", je);
            }
            clazzMetaData = classCX_REMOTE_UNKNOWN_EXCEPTION;
        }
        return clazzMetaData;
    }

    public void setBytes(byte[] xmlBytes) {
        this.numBytes += xmlBytes.length;
        int sumLength = xmlBytes.length + this.remainingBuffer;
        if (sumLength > this.buffer.length) {
            byte[] bufferNew = new byte[sumLength];
            System.arraycopy(this.buffer, 0, bufferNew, 0, this.remainingBuffer);
            this.buffer = bufferNew;
        }
        System.arraycopy(xmlBytes, 0, this.buffer, this.remainingBuffer, xmlBytes.length);
        this.maxFilledPosition = sumLength;
        this.remainingBuffer = 0;
        this.readPosition = 0;
    }

    public void setCompressedBytes(byte[] compressedXmlBytes) throws DataFormatException, XMLParserException {
        this.numBytes += compressedXmlBytes.length;
        this.inflater.setInput(compressedXmlBytes);
        int decompressedBytes = 0;
        while ((decompressedBytes = this.inflater.inflate(this.buffer, this.remainingBuffer, this.buffer.length - this.remainingBuffer)) > 0) {
            this.maxFilledPosition = this.remainingBuffer + decompressedBytes;
            this.remainingBuffer = 0;
            this.readPosition = 0;
            this.parse();
        }
    }

    public void setFinished() throws XMLParserException {
        if (this.inflater != null) {
            if (!this.inflater.finished()) {
                throw new XMLParserException("Compressed BXML document incomplete. Check jrfc protocol traces. [" + this.remainingValueLength + ", " + this.remainingBuffer + ", " + this.hierarchyLevel + ']');
            }
            this.inflater.end();
        }
        if (this.remainingValueLength > 0 || this.remainingBuffer > 0 || this.hierarchyLevel > 0) {
            throw new XMLParserException("BXML document incomplete. Check jrfc protocol traces. [" + this.remainingValueLength + ", " + this.remainingBuffer + ", " + this.hierarchyLevel + ']');
        }
        if (this.recordStack.size() > 0) {
            throw new XMLParserException("BXML parser in invalid final state. Still " + this.recordStack.size() + " records on the stack.");
        }
    }

    public AbapClassExceptionInfo getAbapClassExceptionInfo() throws XMLParserException {
        String cause;
        if (this.exceptionInfo != null) {
            AbstractRecord heapObject = this.heapObjects.get(this.exceptionObjectReference);
            if (heapObject instanceof DefaultAbapObject) {
                DefaultAbapObject referencedHeapObject;
                DefaultAbapObject thrownException = (DefaultAbapObject)heapObject;
                for (String reference : this.references.keySet()) {
                    referencedHeapObject = (DefaultAbapObject)this.heapObjects.get(reference.substring(1));
                    ArrayList<Reference> referenceList = this.references.get(reference);
                    for (Reference iReference : referenceList) {
                        iReference.setValue(referencedHeapObject);
                    }
                }
                for (String reference : this.references.keySet()) {
                    referencedHeapObject = (DefaultAbapObject)this.heapObjects.get(reference.substring(1));
                    referencedHeapObject.setInitialized();
                }
                thrownException.setInitialized();
                this.exceptionInfo.setExceptionInstance(thrownException);
                this.exceptionInfo.setName(this.exceptionName);
                return this.exceptionInfo;
            }
            cause = "No valid exception instance found in serialized data";
        } else {
            cause = "No exception available at all";
        }
        throw new XMLParserException("Failed to extract ABAP class exception: " + cause);
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    static {
        classCX_ROOT.add("CX_ROOT", "TEXTID", 0, 32, JCoClassMetaData.JCoAttributeKind.INSTANCE, true);
        classCX_ROOT.add("CX_ROOT", "PREVIOUS", classCX_ROOT, JCoClassMetaData.JCoAttributeKind.INSTANCE, true);
        classCX_ROOT.add("CX_ROOT", "KERNEL_ERRID", 0, 30, JCoClassMetaData.JCoAttributeKind.INSTANCE, true);
        classCX_ROOT.add("CX_ROOT", "IS_RESUMABLE", 0, 1, JCoClassMetaData.JCoAttributeKind.INSTANCE, true);
        classCX_ROOT.lock();
        classCX_REMOTE_UNKNOWN_EXCEPTION.add("CX_ROOT", "TEXTID", 0, 32, JCoClassMetaData.JCoAttributeKind.INSTANCE, true);
        classCX_REMOTE_UNKNOWN_EXCEPTION.add("CX_ROOT", "PREVIOUS", classCX_ROOT, JCoClassMetaData.JCoAttributeKind.INSTANCE, true);
        classCX_REMOTE_UNKNOWN_EXCEPTION.add("CX_ROOT", "KERNEL_ERRID", 0, 30, JCoClassMetaData.JCoAttributeKind.INSTANCE, true);
        classCX_REMOTE_UNKNOWN_EXCEPTION.add("CX_ROOT", "IS_RESUMABLE", 0, 1, JCoClassMetaData.JCoAttributeKind.INSTANCE, true);
        classCX_REMOTE_UNKNOWN_EXCEPTION.add("CX_REMOTE_EXCEPTION", "DESTINATION", 29, 8, JCoClassMetaData.JCoAttributeKind.INSTANCE, true);
        classCX_REMOTE_UNKNOWN_EXCEPTION.add("CX_REMOTE_UNKNOWN_EXCEPTION", "EXCEPTION_CLASS_NAME", 0, 30, JCoClassMetaData.JCoAttributeKind.INSTANCE, true);
        classCX_REMOTE_UNKNOWN_EXCEPTION.lock();
    }

    private class Reference {
        AbstractRecord container;
        int index;

        public Reference(AbstractRecord container, int index) {
            this.container = container;
            this.index = index;
        }

        public void setValue(DefaultAbapObject abapObject) {
            this.container.setValue(this.index, (JCoAbapObject)abapObject);
        }
    }

    private static enum Mode {
        FUNCTION,
        EXCEPTION,
        HEAP;

    }

    private static enum State {
        INITIAL,
        VERSION,
        ENCODING,
        ENVELOPE,
        PARAMETER,
        DISCARD_PARAMETER,
        DISCARD_VALUE,
        DISCARD_VALUE_RESUMABLE,
        DISCARD_VALUE_CHECK_CHUNK,
        DISCARD_VALUE_CHUNK,
        STRINGID,
        STRINGID_RESUMABLE,
        TEXT,
        TEXT_RESUMABLE,
        TEXT_CHECK_CHUNK,
        TEXT_CHUNK,
        ATTRIBUTE_TEXT,
        ATTRIBUTE_TEXT_RESUMABLE,
        ATTRIBUTE,
        ATTRIBUTE_NAMESPACE,
        BINARY,
        BINARY_RESUMABLE,
        TAG,
        TAG_PURE,
        TAG_NAMESPACE,
        PROCESS_CONTENT,
        PROCESS_CONTENT_DISCARDING,
        HEAP;

    }
}

