Contributing to Jetty
=====================
Thanks for your interest in this project.

Project description
--------------------
Jetty is a lightweight highly scalable java based web server and servlet engine.
Our goal is to support web protocols like HTTP, HTTP/2, and WebSocket in a high
volume low latency way that provides maximum performance while retaining the ease
of use and compatibility with years of servlet development.
Jetty is a modern fully async web server that has a long history as a component
oriented technology easily embedded into applications while still offering a solid
traditional distribution for webapp deployment.

- [https://projects.eclipse.org/projects/rt.jetty](https://projects.eclipse.org/projects/rt.jetty)

Developer resources
--------------------
Information regarding source code management, builds, coding standards, and more.

- [https://www.eclipse.org/jetty/documentation/current/advanced-contributing.html](https://www.eclipse.org/jetty/documentation/current/advanced-contributing.html)

The canonical Jetty git repository is located at GitHub.  Providing you have
completed the contributors agreement mentioned below we will endeavor to pull
your commit into Jetty proper.

Contributor License Agreement
------------------------------
Before your contribution can be accepted by the project, you need to create and electronically sign the
Eclipse Foundation [Contributor License Agreement](https://www.eclipse.org/legal/CLA.php) (CLA):

1. Log in to the [Eclipse projects forge](https://projects.eclipse.org/user/login/sso). You will need to
   create an account with the Eclipse Foundation if you have not already done so.
2. Click on "Contributor License Agreement", and complete the form.

Be sure to use the same email address in your Eclipse account that you intend to use when you commit to Git.

Contact
--------
Contact the project developers via the project's "dev" list.

- [https://dev.eclipse.org/mailman/listinfo/jetty-dev](https://dev.eclipse.org/mailman/listinfo/jetty-dev)

Search for bugs
----------------
This project uses GitHub Issues to track ongoing development and issues.

- [https://github.com/eclipse/jetty.project/issues](https://github.com/eclipse/jetty.project/issues)

Create a new bug
-----------------
Be sure to search for existing bugs before you create another one. Remember that contributions are always welcome!

- [https://github.com/eclipse/jetty.project/issues](https://github.com/eclipse/jetty.project/issues)

Reporting Security Issues
-----------------
There are a number of avenues for reporting security issues to the Jetty project available. 
If the issue is directly related to Jetty itself then reporting to the Jetty developers is encouraged. 
The most direct method is to mail [security@webtide.com](mailto:security@webtide.com). 
Webtide is comprised of the active committers of the Jetty project is our preferred reporting method. 
We are flexible in how we work with reporters of security issues but we reserve the right to act in the interests of the Jetty project in all circumstances.

If the issue is related to Eclipse or its Jetty integration then we encourage you to reach out to [security@eclipse.org](mailto:security@eclipse.org).
