/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"fmt"

	v1alpha1 "github.com/artemiscloud/activemq-artemis-operator/api/v1alpha1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ActiveMQArtemisSecurityLister helps list ActiveMQArtemisSecurities.
type ActiveMQArtemisSecurityLister interface {
	// List lists all ActiveMQArtemisSecurities in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.ActiveMQArtemisSecurity, err error)
	// ActiveMQArtemisSecurities returns an object that can list and get ActiveMQArtemisSecurities.
	ActiveMQArtemisSecurities(namespace string) ActiveMQArtemisSecurityNamespaceLister
	ActiveMQArtemisSecurityListerExpansion
}

// activeMQArtemisSecurityLister implements the ActiveMQArtemisSecurityLister interface.
type activeMQArtemisSecurityLister struct {
	indexer cache.Indexer
}

// NewActiveMQArtemisSecurityLister returns a new ActiveMQArtemisSecurityLister.
func NewActiveMQArtemisSecurityLister(indexer cache.Indexer) ActiveMQArtemisSecurityLister {
	return &activeMQArtemisSecurityLister{indexer: indexer}
}

// List lists all ActiveMQArtemisSecurities in the indexer.
func (s *activeMQArtemisSecurityLister) List(selector labels.Selector) (ret []*v1alpha1.ActiveMQArtemisSecurity, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ActiveMQArtemisSecurity))
	})
	return ret, err
}

// ActiveMQArtemisSecurities returns an object that can list and get ActiveMQArtemisSecurities.
func (s *activeMQArtemisSecurityLister) ActiveMQArtemisSecurities(namespace string) ActiveMQArtemisSecurityNamespaceLister {
	return activeMQArtemisSecurityNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ActiveMQArtemisSecurityNamespaceLister helps list and get ActiveMQArtemisSecurity.
type ActiveMQArtemisSecurityNamespaceLister interface {
	// List lists all ActiveMQArtemisSecurities in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.ActiveMQArtemisSecurity, err error)
	// Get retrieves the ActiveMQArtemisSecurity from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.ActiveMQArtemisSecurity, error)
	ActiveMQArtemisSecurityNamespaceListerExpansion
}

// activeMQArtemisSecurityNamespaceLister implements the ActiveMQArtemisSecurityNamespaceLister
// interface.
type activeMQArtemisSecurityNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ActiveMQArtemisAddresses in the indexer for a given namespace.
func (s activeMQArtemisSecurityNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.ActiveMQArtemisSecurity, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ActiveMQArtemisSecurity))
	})
	return ret, err
}

// Get retrieves the ActiveMQArtemisSecurity from the indexer for a given namespace and name.
func (s activeMQArtemisSecurityNamespaceLister) Get(name string) (*v1alpha1.ActiveMQArtemisSecurity, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, fmt.Errorf("activemqartemisSecurity not found: %s", name)
	}
	return obj.(*v1alpha1.ActiveMQArtemisSecurity), nil
}
