#! /bin/bash

function find_odcs_composes() {

    local YUMDIR="${1:-/etc/yum.repos.d/}"
    find "$YUMDIR" \
         \( -iname "odcs-*-debug.repo" -prune \) -o \
         \( -iname "odcs-*.repo" -print \)
}


function enable_debuginfo() {
    local REPO="$1"

    if ! grep -q 'baseurl=.*compose/Temporary/\$basearch/os$' "$REPO" ; then
        # quick sanity check
        echo "Not an ODCS compose repo: $REPO"
        return 0
    fi

    # pick a filename for the new debug repo
    local DEBUG_REPO=$(sed 's,\.repo$,-debug.repo,g' <<< "$REPO")

    # and now do some regex swaps on the original to produce the debug repo
    sed \
        -e 's,\[\(odcs-.*\)\],\[\1-debug\],g' \
        -e 's,name=\(.*\),name=\1-debuginfo,g' \
        -e 's,baseurl=\(.*\)/os,baseurl=\1/debug/tree,g' \
        "$REPO" | tee "$DEBUG_REPO"
}


for I in $(find_odcs_composes "$1") ; do
     enable_debuginfo "$I"
done

