/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest;

import io.strimzi.test.TestUtils;
import java.time.Duration;

public interface Constants {
    public static final long TIMEOUT_FOR_RESOURCE_RECOVERY = Duration.ofMinutes(6L).toMillis();
    public static final long TIMEOUT_FOR_MIRROR_MAKER_COPY_MESSAGES_BETWEEN_BROKERS = Duration.ofMinutes(7L).toMillis();
    public static final long TIMEOUT_FOR_LOG = Duration.ofMinutes(2L).toMillis();
    public static final long POLL_INTERVAL_FOR_RESOURCE_CREATION = Duration.ofSeconds(3L).toMillis();
    public static final long POLL_INTERVAL_FOR_RESOURCE_READINESS = Duration.ofSeconds(1L).toMillis();
    public static final long POLL_INTERVAL_FOR_RESOURCE_DELETION = Duration.ofSeconds(5L).toMillis();
    public static final long WAIT_FOR_ROLLING_UPDATE_INTERVAL = Duration.ofSeconds(5L).toMillis();
    public static final long TIMEOUT_FOR_SEND_RECEIVE_MSG = Duration.ofSeconds(60L).toMillis();
    public static final long TIMEOUT_AVAILABILITY_TEST = Duration.ofMinutes(1L).toMillis();
    public static final long TIMEOUT_FOR_CLUSTER_STABLE = Duration.ofMinutes(20L).toMillis();
    public static final long TIMEOUT_TEARDOWN = Duration.ofSeconds(10L).toMillis();
    public static final long GLOBAL_TIMEOUT = Duration.ofMinutes(5L).toMillis();
    public static final long GLOBAL_STATUS_TIMEOUT = Duration.ofMinutes(3L).toMillis();
    public static final long GLOBAL_POLL_INTERVAL = Duration.ofSeconds(1L).toMillis();
    public static final long GLOBAL_POLL_INTERVAL_MEDIUM = Duration.ofSeconds(10L).toMillis();
    public static final long PRODUCER_TIMEOUT = Duration.ofSeconds(25L).toMillis();
    public static final long GLOBAL_TRACING_POLL = Duration.ofSeconds(30L).toMillis();
    public static final long API_CRUISE_CONTROL_POLL = Duration.ofSeconds(5L).toMillis();
    public static final long API_CRUISE_CONTROL_TIMEOUT = Duration.ofMinutes(10L).toMillis();
    public static final long GLOBAL_CRUISE_CONTROL_TIMEOUT = Duration.ofMinutes(1L).toMillis();
    public static final long OLM_UPGRADE_INSTALL_PLAN_TIMEOUT = Duration.ofMinutes(15L).toMillis();
    public static final long OLM_UPGRADE_INSTALL_PLAN_POLL = Duration.ofMinutes(1L).toMillis();
    public static final long GLOBAL_CLIENTS_POLL = Duration.ofSeconds(15L).toMillis();
    public static final long GLOBAL_CLIENTS_TIMEOUT = Duration.ofMinutes(2L).toMillis();
    public static final long HUGE_CLIENTS_TIMEOUT = Duration.ofMinutes(30L).toMillis();
    public static final long GLOBAL_CLIENTS_EXCEPT_ERROR_TIMEOUT = Duration.ofSeconds(10L).toMillis();
    public static final long CO_OPERATION_TIMEOUT_DEFAULT = Duration.ofMinutes(5L).toMillis();
    public static final long CO_OPERATION_TIMEOUT_SHORT = Duration.ofSeconds(30L).toMillis();
    public static final long CO_OPERATION_TIMEOUT_MEDIUM = Duration.ofMinutes(2L).toMillis();
    public static final long RECONCILIATION_INTERVAL = Duration.ofSeconds(30L).toMillis();
    public static final long LOGGING_RELOADING_INTERVAL = Duration.ofSeconds(30L).toMillis();
    public static final int GLOBAL_STABILITY_OFFSET_COUNT = 20;
    public static final int GLOBAL_RECONCILIATION_COUNT = (int)(RECONCILIATION_INTERVAL / GLOBAL_POLL_INTERVAL + 20L);
    public static final String KAFKA_CLIENTS_LABEL_KEY = "user-test-app";
    public static final String KAFKA_CLIENTS_LABEL_VALUE = "kafka-clients";
    public static final String KAFKA_BRIDGE_CLIENTS_LABEL_VALUE = "kafka-clients";
    public static final String KAFKA_CLIENTS = "kafka-clients";
    public static final String STRIMZI_DEPLOYMENT_NAME = "strimzi-cluster-operator";
    public static final String ALWAYS_IMAGE_PULL_POLICY = "Always";
    public static final String IF_NOT_PRESENT_IMAGE_PULL_POLICY = "IfNotPresent";
    public static final String STRIMZI_EXAMPLE_PRODUCER_NAME = "java-kafka-producer";
    public static final String STRIMZI_EXAMPLE_CONSUMER_NAME = "java-kafka-consumer";
    public static final String STRIMZI_EXAMPLE_STREAMS_NAME = "java-kafka-streams";
    public static final int HTTP_KEYCLOAK_DEFAULT_PORT = 8080;
    public static final int HTTPS_KEYCLOAK_DEFAULT_PORT = 8443;
    public static final int COMPONENTS_METRICS_PORT = 9404;
    public static final int CLUSTER_OPERATOR_METRICS_PORT = 8080;
    public static final int USER_OPERATOR_METRICS_PORT = 8081;
    public static final int TOPIC_OPERATOR_METRICS_PORT = 8080;
    public static final int KAFKA_BRIDGE_METRICS_PORT = 8080;
    public static final String DEPLOYMENT = "Deployment";
    public static final String SERVICE = "Service";
    public static final String INGRESS = "Ingress";
    public static final String CLUSTER_ROLE_BINDING = "ClusterRoleBinding";
    public static final String ROLE_BINDING = "RoleBinding";
    public static final String DEPLOYMENT_CONFIG = "DeploymentConfig";
    public static final String SECRET = "Secret";
    public static final String KAFKA_EXPORTER_DEPLOYMENT = "KafkaWithExporter";
    public static final String KAFKA_CRUISE_CONTROL_DEPLOYMENT = "KafkaWithCruiseControl";
    public static final String STATEFUL_SET = "StatefulSet";
    public static final String POD = "Pod";
    public static final String KAFKA_BRIDGE_JSON_JSON = "application/vnd.kafka.json.v2+json";
    public static final String KAFKA_BRIDGE_JSON = "application/vnd.kafka.v2+json";
    public static final String DEFAULT_SINK_FILE_PATH = "/tmp/test-file-sink.txt";
    public static final int HTTP_BRIDGE_DEFAULT_PORT = 8080;
    public static final int HTTP_JAEGER_DEFAULT_TCP_PORT = 5778;
    public static final int HTTP_JAEGER_DEFAULT_NODE_PORT = 32480;
    public static final int HTTPS_KEYCLOAK_DEFAULT_NODE_PORT = 32481;
    public static final int HTTP_KEYCLOAK_DEFAULT_NODE_PORT = 32482;
    public static final String PATH_TO_KAFKA_METRICS_CONFIG = TestUtils.USER_PATH + "/../examples/metrics/kafka-metrics.yaml";
    public static final String PATH_TO_KAFKA_CRUISE_CONTROL_METRICS_CONFIG = TestUtils.USER_PATH + "/../examples/metrics/kafka-cruise-control-metrics.yaml";
    public static final String PATH_TO_KAFKA_CONNECT_METRICS_CONFIG = TestUtils.USER_PATH + "/../examples/metrics/kafka-connect-metrics.yaml";
    public static final String PATH_TO_KAFKA_CONNECT_S2I_CONFIG = TestUtils.USER_PATH + "/../examples/connect/kafka-connect-s2i.yaml";
    public static final String PATH_TO_KAFKA_MIRROR_MAKER_2_METRICS_CONFIG = TestUtils.USER_PATH + "/../examples/metrics/kafka-mirror-maker-2-metrics.yaml";
    public static final String METRICS_CONFIG_YAML_NAME = "metrics-config.yml";
    public static final String DEFAULT_TAG = "all";
    public static final String ACCEPTANCE = "acceptance";
    public static final String REGRESSION = "regression";
    public static final String UPGRADE = "upgrade";
    public static final String OLM_UPGRADE = "olmupgrade";
    public static final String SMOKE = "smoke";
    public static final String FLAKY = "flaky";
    public static final String SCALABILITY = "scalability";
    public static final String SPECIFIC = "specific";
    public static final String NODEPORT_SUPPORTED = "nodeport";
    public static final String LOADBALANCER_SUPPORTED = "loadbalancer";
    public static final String NETWORKPOLICIES_SUPPORTED = "networkpolicies";
    public static final String PROMETHEUS = "prometheus";
    public static final String TRACING = "tracing";
    public static final String HELM = "helm";
    public static final String OAUTH = "oauth";
    public static final String RECOVERY = "recovery";
    public static final String CONNECTOR_OPERATOR = "connectoroperator";
    public static final String CONNECT = "connect";
    public static final String CONNECT_S2I = "connects2i";
    public static final String MIRROR_MAKER = "mirrormaker";
    public static final String MIRROR_MAKER2 = "mirrormaker2";
    public static final String CONNECT_COMPONENTS = "connectcomponents";
    public static final String BRIDGE = "bridge";
    public static final String INTERNAL_CLIENTS_USED = "internalclients";
    public static final String EXTERNAL_CLIENTS_USED = "externalclients";
    public static final String METRICS = "metrics";
    public static final String CRUISE_CONTROL = "cruisecontrol";
    public static final String DYNAMIC_CONFIGURATION = "dynamicconfiguration";
    public static final String ROLLING_UPDATE = "rollingupdate";
    public static final String OLM = "olm";
    public static final String CRUISE_CONTROL_NAME = "Cruise Control";
    public static final String CRUISE_CONTROL_CONTAINER_NAME = "cruise-control";
    public static final String CRUISE_CONTROL_CONFIGURATION_ENV = "CRUISE_CONTROL_CONFIGURATION";
    public static final String CRUISE_CONTROL_CAPACITY_FILE_PATH = "/tmp/capacity.json";
    public static final String CRUISE_CONTROL_CONFIGURATION_FILE_PATH = "/tmp/cruisecontrol.properties";
    public static final String PLAIN_LISTENER_DEFAULT_NAME = "plain";
    public static final String TLS_LISTENER_DEFAULT_NAME = "tls";
    public static final String EXTERNAL_LISTENER_DEFAULT_NAME = "external";
}

