/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.kafkaclients.clientproperties;

import io.strimzi.systemtest.kafkaclients.clientproperties.AbstractKafkaClientProperties;
import java.util.Locale;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConsumerProperties
extends AbstractKafkaClientProperties<ConsumerProperties> {
    private static final Logger LOGGER = LogManager.getLogger(ConsumerProperties.class);

    private ConsumerProperties(ConsumerPropertiesBuilder builder) {
        super(builder);
        this.properties = builder.properties;
    }

    public ConsumerPropertiesBuilder toBuilder(ConsumerProperties clientProperties) {
        ConsumerPropertiesBuilder builder = new ConsumerPropertiesBuilder();
        builder.withNamespaceName(clientProperties.getNamespaceName());
        builder.withClusterName(clientProperties.getClusterName());
        builder.withSecurityProtocol(SecurityProtocol.forName((String)clientProperties.getProperties().getProperty("security.protocol")));
        builder.withBootstrapServerConfig(clientProperties.getProperties().getProperty("bootstrap.servers"));
        builder.withGroupIdConfig(clientProperties.getProperties().getProperty("group.id"));
        try {
            builder.withKeyDeserializerConfig(Class.forName(clientProperties.getProperties().getProperty("key.deserializer")));
            builder.withValueDeserializerConfig(Class.forName(clientProperties.getProperties().getProperty("value.deserializer")));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        builder.withClientIdConfig(clientProperties.getProperties().getProperty("client.id"));
        builder.withAutoOffsetResetConfig(OffsetResetStrategy.valueOf((String)clientProperties.getProperties().getProperty("auto.offset.reset").toUpperCase(Locale.ENGLISH)));
        builder.withSharedProperties();
        return builder;
    }

    public static class ConsumerPropertiesBuilder
    extends AbstractKafkaClientProperties.KafkaClientPropertiesBuilder<ConsumerPropertiesBuilder> {
        public ConsumerPropertiesBuilder withBootstrapServerConfig(String bootstrapServer) {
            this.properties.setProperty("bootstrap.servers", bootstrapServer);
            return this;
        }

        public ConsumerPropertiesBuilder withKeyDeserializerConfig(Class<? extends Deserializer> keyDeSerializer) {
            this.properties.setProperty("key.deserializer", keyDeSerializer.getName());
            return this;
        }

        public ConsumerPropertiesBuilder withValueDeserializerConfig(Class<? extends Deserializer> valueDeSerializer) {
            this.properties.setProperty("value.deserializer", valueDeSerializer.getName());
            return this;
        }

        public ConsumerPropertiesBuilder withGroupIdConfig(String groupIdConfig) {
            this.properties.setProperty("group.id", groupIdConfig);
            return this;
        }

        public ConsumerPropertiesBuilder withClientIdConfig(String clientId) {
            this.properties.setProperty("client.id", clientId);
            return this;
        }

        public ConsumerPropertiesBuilder withAutoOffsetResetConfig(OffsetResetStrategy offsetResetConfig) {
            this.properties.setProperty("auto.offset.reset", offsetResetConfig.name().toLowerCase(Locale.ENGLISH));
            return this;
        }

        public ConsumerProperties build() {
            return new ConsumerProperties(this);
        }

        @Override
        protected ConsumerPropertiesBuilder self() {
            return this;
        }
    }
}

