/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.systemtest.utils.kafkaUtils;

import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.model.KafkaConnector;
import io.strimzi.systemtest.Constants;
import io.strimzi.systemtest.enums.CustomResourceStatus;
import io.strimzi.systemtest.resources.ResourceManager;
import io.strimzi.systemtest.resources.ResourceOperation;
import io.strimzi.systemtest.resources.crd.KafkaConnectorResource;
import io.strimzi.test.TestUtils;
import io.strimzi.test.k8s.KubeClusterResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KafkaConnectorUtils {
    private static final Logger LOGGER = LogManager.getLogger(KafkaConnectorUtils.class);
    private static final long READINESS_TIMEOUT = ResourceOperation.getTimeoutForResourceReadiness("KafkaConnector");

    private KafkaConnectorUtils() {
    }

    public static void waitForConnectorStability(String connectorName, String connectPodName) {
        int[] i = new int[]{0};
        TestUtils.waitFor((String)("Waiting for stability of connector " + connectorName), (long)Constants.GLOBAL_POLL_INTERVAL, (long)Constants.GLOBAL_TIMEOUT, () -> {
            String availableConnectors = KafkaConnectorUtils.getCreatedConnectors(connectPodName);
            if (availableConnectors.contains(connectorName)) {
                LOGGER.info("Connector with name {} is present. Remaining seconds for stability {}", (Object)connectorName, (Object)(Constants.GLOBAL_RECONCILIATION_COUNT - i[0]));
                int n = i[0];
                i[0] = n + 1;
                return n == Constants.GLOBAL_RECONCILIATION_COUNT;
            }
            throw new RuntimeException("Connector" + connectorName + " is not stable!");
        }, () -> ResourceManager.logCurrentResourceStatus((KafkaConnector)((Resource)((NonNamespaceOperation)KafkaConnectorResource.kafkaConnectorClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(connectorName)).get()));
    }

    public static void waitForConnectorStatus(String connectorName, Enum<?> state) {
        KafkaConnector kafkaConnector = (KafkaConnector)((Resource)((NonNamespaceOperation)KafkaConnectorResource.kafkaConnectorClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(connectorName)).get();
        ResourceManager.waitForResourceStatus(KafkaConnectorResource.kafkaConnectorClient(), kafkaConnector, state);
    }

    public static void waitForConnectorReady(String connectorName) {
        KafkaConnectorUtils.waitForConnectorStatus(connectorName, CustomResourceStatus.Ready);
    }

    public static void waitForConnectorNotReady(String connectorName) {
        KafkaConnectorUtils.waitForConnectorStatus(connectorName, CustomResourceStatus.NotReady);
    }

    public static String getCreatedConnectors(String connectPodName) {
        return KubeClusterResource.cmdKubeClient().execInPod(connectPodName, new String[]{"/bin/bash", "-c", "curl -X GET http://localhost:8083/connectors"}).out();
    }

    public static void waitForConnectorCreation(String connectS2IPodName, String connectorName) {
        TestUtils.waitFor((String)(connectorName + " connector creation"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)READINESS_TIMEOUT, () -> {
            String availableConnectors = KafkaConnectorUtils.getCreatedConnectors(connectS2IPodName);
            return availableConnectors.contains(connectorName);
        }, () -> ResourceManager.logCurrentResourceStatus((KafkaConnector)((Resource)((NonNamespaceOperation)KafkaConnectorResource.kafkaConnectorClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(connectorName)).get()));
    }

    public static void waitForConnectorDeletion(String connectorName) {
        TestUtils.waitFor((String)(connectorName + " connector deletion"), (long)Constants.GLOBAL_POLL_INTERVAL, (long)READINESS_TIMEOUT, () -> {
            if (((Resource)((NonNamespaceOperation)KafkaConnectorResource.kafkaConnectorClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(connectorName)).get() == null) {
                return true;
            }
            LOGGER.info("KafkaConnector: {} is not deleted yet, triggering force delete", (Object)connectorName);
            KubeClusterResource.cmdKubeClient().deleteByName("KafkaConnector", connectorName);
            return false;
        }, () -> ResourceManager.logCurrentResourceStatus((KafkaConnector)((Resource)((NonNamespaceOperation)KafkaConnectorResource.kafkaConnectorClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(connectorName)).get()));
    }

    public static void createFileSinkConnector(String podName, String topicName, String sinkFileName, String apiUrl) {
        KubeClusterResource.cmdKubeClient().execInPod(podName, new String[]{"/bin/bash", "-c", "curl -X POST -H \"Content-Type: application/json\" --data '{ \"name\": \"sink-test\", \"config\": { \"connector.class\": \"FileStreamSink\", \"tasks.max\": \"1\", \"topics\": \"" + topicName + "\", \"file\": \"" + sinkFileName + "\" } }' " + apiUrl + "/connectors"});
    }

    public static void waitForConnectorsTaskMaxChange(String connectorName, int taskMax) {
        TestUtils.waitFor((String)"Wait for KafkaConnector taskMax will change", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)Constants.GLOBAL_TIMEOUT, () -> ((KafkaConnector)((Resource)((NonNamespaceOperation)KafkaConnectorResource.kafkaConnectorClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(connectorName)).get()).getSpec().getTasksMax() == taskMax && ((KafkaConnector)((Resource)((NonNamespaceOperation)KafkaConnectorResource.kafkaConnectorClient().inNamespace(KubeClusterResource.kubeClient().getNamespace())).withName(connectorName)).get()).getStatus().getTasksMax() == taskMax);
    }

    public static String getConnectorSpecFromConnectAPI(String podName, String connectorName) {
        return KubeClusterResource.cmdKubeClient().execInPod(podName, new String[]{"/bin/bash", "-c", "curl http://localhost:8083/connectors/" + connectorName}).out();
    }

    public static String getConnectorConfig(String podName, String connectorName, String apiUrl) {
        return KubeClusterResource.cmdKubeClient().execInPod(podName, new String[]{"/bin/bash", "-c", "curl http://" + apiUrl + ":8083/connectors/" + connectorName + "/config"}).out();
    }

    public static String waitForConnectorConfigUpdate(String podName, String connectorName, String oldConfig, String apiUrl) {
        TestUtils.waitFor((String)"Wait for KafkaConnector config will contain desired config", (long)Constants.POLL_INTERVAL_FOR_RESOURCE_READINESS, (long)ResourceOperation.getTimeoutForResourceReadiness("KafkaConnector"), () -> !oldConfig.equals(KafkaConnectorUtils.getConnectorConfig(podName, connectorName, apiUrl)));
        return KafkaConnectorUtils.getConnectorConfig(podName, connectorName, apiUrl);
    }
}

