/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Replicas {
    public static final int[] NONE = new int[0];

    public static List<Integer> toList(int[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static int[] toArray(List<Integer> list) {
        if (list == null) {
            return null;
        }
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static int[] clone(int[] array) {
        int[] clone = new int[array.length];
        System.arraycopy(array, 0, clone, 0, array.length);
        return clone;
    }

    public static boolean validate(int[] replicas) {
        if (replicas.length == 0) {
            return true;
        }
        int[] sortedReplicas = Replicas.clone(replicas);
        Arrays.sort(sortedReplicas);
        int prev = sortedReplicas[0];
        if (prev < 0) {
            return false;
        }
        for (int i = 1; i < sortedReplicas.length; ++i) {
            int replica = sortedReplicas[i];
            if (prev == replica) {
                return false;
            }
            prev = replica;
        }
        return true;
    }

    public static boolean validateIsr(int[] replicas, int[] isr) {
        if (isr.length == 0) {
            return true;
        }
        if (replicas.length == 0) {
            return false;
        }
        int[] sortedReplicas = Replicas.clone(replicas);
        Arrays.sort(sortedReplicas);
        int[] sortedIsr = Replicas.clone(isr);
        Arrays.sort(sortedIsr);
        int j = 0;
        if (sortedIsr[0] < 0) {
            return false;
        }
        int prevIsr = -1;
        for (int i = 0; i < sortedIsr.length; ++i) {
            int curReplica;
            int curIsr = sortedIsr[i];
            if (prevIsr == curIsr) {
                return false;
            }
            prevIsr = curIsr;
            do {
                if (j != sortedReplicas.length) continue;
                return false;
            } while ((curReplica = sortedReplicas[j++]) != curIsr);
        }
        return true;
    }

    public static boolean contains(int[] replicas, int value) {
        for (int i = 0; i < replicas.length; ++i) {
            if (replicas[i] != value) continue;
            return true;
        }
        return false;
    }

    public static int[] copyWithout(int[] replicas, int value) {
        int size = 0;
        for (int i = 0; i < replicas.length; ++i) {
            if (replicas[i] == value) continue;
            ++size;
        }
        int[] result = new int[size];
        int j = 0;
        for (int i = 0; i < replicas.length; ++i) {
            int replica = replicas[i];
            if (replica == value) continue;
            result[j++] = replica;
        }
        return result;
    }

    public static int[] copyWith(int[] replicas, int value) {
        int[] newReplicas = new int[replicas.length + 1];
        System.arraycopy(replicas, 0, newReplicas, 0, replicas.length);
        newReplicas[newReplicas.length - 1] = value;
        return newReplicas;
    }
}

