import type { Meta, StoryObj } from "@storybook/react";
import { expect, within } from "@storybook/test";
import { NoData as Comp } from "./NoData";

const meta: Meta<typeof Comp> = {
  component: Comp,
};

export default meta;
type Story = StoryObj<typeof Comp>;

export const NoData: Story = {
  play: async ({ canvasElement }) => {
    const canvas = within(canvasElement);
    expect(canvas.getByText("No data"));
  },
};
