# **Kafka** 

## Description

These tests validate the core Apache Kafka functionality within the Strimzi ecosystem, ensuring the reliability, scalability, and correctness of Kafka clusters. 
They cover various aspects such as dynamic configuration updates, listener configurations, node pool management, version upgrades, quotas, and tiered storage. 
These tests are crucial to ensure that Kafka clusters can handle production workloads.

<!-- generated part -->
**Tests:**
- [testReadOnlyRootFileSystem](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testLabelsExistenceAndManipulation](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testSendMessagesCustomListenerTlsScramSha](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testDynConfiguration](../io.strimzi.systemtest.kafka.dynamicconfiguration.DynamicConfSharedST.md)
- [testKafkaJBODDeleteClaimsTrueFalse](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testCertificateWithNonExistingDataKey](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testResizeJbodVolumes](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testCertificateWithNonExistingDataCrt](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCombinationOfEveryKindOfListener](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testSendMessagesTlsScramSha](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testMixtureOfExternalListeners](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testMessagesTlsScramShaWithPredefinedPassword](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testKafkaManagementTransferToAndFromKafkaNodePool](../io.strimzi.systemtest.kafka.KafkaNodePoolST.md)
- [testCustomSoloCertificatesForLoadBalancer](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomChainCertificatesForRoute](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCombinationOfInternalAndExternalListeners](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testClusterIp](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomCertRouteAndTlsRollingUpdate](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testRegenerateCertExternalAddressChange](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testJvmAndResources](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testMultipleLoadBalancers](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testUpdateToExternalListenerCausesRollingRestart](../io.strimzi.systemtest.kafka.dynamicconfiguration.DynamicConfST.md)
- [testKafkaWithVersion](../io.strimzi.systemtest.kafka.KafkaVersionsST.md)
- [testClusterIpTls](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testMessagesAndConsumerOffsetFilesOnDisk](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testDeployUnsupportedKafka](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testRemoveComponentsFromEntityOperator](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testCustomChainCertificatesForLoadBalancer](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomChainCertificatesForNodePort](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testMultipleRoutes](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testSendMessagesPlainAnonymous](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testOverrideNodePortConfiguration](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testTieredStorageWithAivenPlugin](../io.strimzi.systemtest.kafka.TieredStorageST.md)
- [testLoadBalancerTls](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testNodePoolsRolesChanging](../io.strimzi.systemtest.kafka.KafkaNodePoolST.md)
- [testNodePort](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testSendMessagesPlainScramSha](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testCustomSoloCertificatesForRoute](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testUpdateToExternalListenerCausesRollingRestartUsingExternalClients](../io.strimzi.systemtest.kafka.dynamicconfiguration.DynamicConfST.md)
- [testNodePortTls](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testNonExistingCustomCertificate](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testSendMessagesTlsAuthenticated](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testAdvertisedHostNamesAppearsInBrokerCerts](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testNodePoolsAdditionAndRemoval](../io.strimzi.systemtest.kafka.KafkaNodePoolST.md)
- [testAdditionalVolumes](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testMultipleNodePorts](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testCustomCertNodePortAndTlsRollingUpdate](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testKafkaQuotasPluginWithBandwidthLimitation](../io.strimzi.systemtest.kafka.QuotasST.md)
- [testKRaftMode](../io.strimzi.systemtest.kafka.KafkaST.md)
- [testKafkaNodePoolBrokerIdsManagementUsingAnnotations](../io.strimzi.systemtest.kafka.KafkaNodePoolST.md)
- [testLoadBalancer](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testKafkaQuotasPluginIntegration](../io.strimzi.systemtest.kafka.QuotasST.md)
- [testCustomCertLoadBalancerAndTlsRollingUpdate](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testSimpleDynamicConfiguration](../io.strimzi.systemtest.kafka.dynamicconfiguration.DynamicConfST.md)
- [testMultipleInternal](../io.strimzi.systemtest.kafka.listeners.MultipleListenersST.md)
- [testCustomSoloCertificatesForNodePort](../io.strimzi.systemtest.kafka.listeners.ListenersST.md)
- [testConnectWithConnectorUsingConfigAndEnvProvider](../io.strimzi.systemtest.kafka.ConfigProviderST.md)
