/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.pipeliner;

import 6bc6660d778dec84d62bc72b295ffd7b.org.yaml.snakeyaml.error.MarkedYAMLException;
import 6bc6660d778dec84d62bc72b295ffd7b.picocli.CommandLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.verifyica.pipeliner.common.Console;
import org.verifyica.pipeliner.common.ValidatorException;
import org.verifyica.pipeliner.common.Version;
import org.verifyica.pipeliner.core.Job;
import org.verifyica.pipeliner.core.Pipeline;
import org.verifyica.pipeliner.core.Run;
import org.verifyica.pipeliner.core.Step;
import org.verifyica.pipeliner.core.parser.PipelineParser;

public class Converter
implements Runnable {
    @CommandLine.Option(names={"--version"}, description={"show version"})
    private boolean showVersion;
    @CommandLine.Option(names={"--reverse"}, description={"reverse conversion"})
    private boolean reverse;
    @CommandLine.Parameters(description={"arguments"})
    private List<String> args;

    private Converter() {
    }

    @Override
    public void run() {
        if (this.showVersion) {
            System.out.println("@info Verifyica Converter " + Version.getVersion() + " (https://github.com/verifyica-team/pipeliner)");
            System.out.flush();
            System.exit(0);
        }
        if (this.args == null || this.args.size() != 1) {
            System.exit(1);
        }
        try {
            File file = new File(this.args.get(0));
            String absoluteFilename = file.getAbsolutePath();
            if (!file.exists()) {
                throw new IllegalArgumentException(String.format("filename [%s] doesn't exist", absoluteFilename));
            }
            if (!file.isFile()) {
                throw new IllegalArgumentException(String.format("filename [%s] is a directory", absoluteFilename));
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException(String.format("filename [%s] is not readable", absoluteFilename));
            }
            if (this.reverse) {
                this.reverseConvert(file);
            } else {
                this.convert(file);
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            System.exit(1);
        }
    }

    private void reverseConvert(File file) throws ValidatorException, MarkedYAMLException, IOException {
        String pipelinerWorkingDirectory = file.getAbsoluteFile().getParent();
        Console console = new Console();
        Pipeline pipeline = new PipelineParser(console).parse(file.getAbsolutePath());
        System.out.println("# pipeline name=[" + pipeline.getName() + "]");
        for (Job job : pipeline.getJobs()) {
            System.out.println("# job name=[" + job.getName() + "]");
            if (!job.isEnabled()) {
                System.out.println("# job name=[" + job.getName() + "] enabled=[false]");
                continue;
            }
            for (Step step : job.getSteps()) {
                System.out.println("# step name=[" + step.getName() + "]");
                if (!step.isEnabled()) {
                    System.out.println("# step name=[" + step.getName() + "] enabled=[false]");
                    continue;
                }
                if (".".equals(step.getWorkingDirectory())) {
                    System.out.println("cd " + pipelinerWorkingDirectory);
                } else if (step.getWorkingDirectory().startsWith("/")) {
                    System.out.println("cd " + step.getWorkingDirectory());
                } else {
                    System.out.println("cd " + pipelinerWorkingDirectory + File.separator + step.getWorkingDirectory());
                }
                for (Run run : step.getRuns()) {
                    String command = run.getCommand();
                    command = command.replaceAll(Pattern.quote("$PIPELINER_HOME"), System.getenv("PIPELINER_HOME"));
                    System.out.println(command);
                }
                System.out.println("cd " + pipelinerWorkingDirectory);
            }
        }
    }

    private void convert(File file) throws IOException {
        int jobIndex = 1;
        int stepIndex = 1;
        ArrayList<String> workingDirectories = new ArrayList<String>();
        this.log("pipeline:");
        this.log(2, "name: pipeline-" + Converter.toPipelineName(file.getName()));
        this.log(2, "id: pipeline-" + Converter.toPipelineId(file.getName()));
        this.log(2, "jobs:");
        this.log(4, "- name: pipeline-job-" + jobIndex);
        this.log(4, "  id: pipeline-job-" + jobIndex);
        this.log(4, "  enabled: true");
        this.log(4, "  steps:");
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if ((line = line.trim()).startsWith("cd ")) {
                    workingDirectories.add(line.substring(3));
                    continue;
                }
                this.log(8, "- name: pipeline-job-" + jobIndex + "-step-" + stepIndex);
                this.log(8, "  id: pipeline-job-" + jobIndex + "-step-" + stepIndex);
                this.log(8, "  enabled: true");
                String workingDirectory = this.flatten(workingDirectories);
                if (!workingDirectory.equals(".")) {
                    this.log(8, "  working-directory: " + workingDirectory);
                }
                this.log(8, "  run: " + line);
                workingDirectories.clear();
                ++stepIndex;
            }
        }
    }

    private String flatten(List<String> workingDirectories) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = workingDirectories.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(File.separator);
        }
        String workingDirectory = stringBuilder.toString();
        return !workingDirectory.isEmpty() ? workingDirectory : ".";
    }

    private void log(int spaces, Object object) {
        for (int i = 0; i < spaces; ++i) {
            System.out.print(" ");
        }
        this.log(object);
    }

    private void log(Object object) {
        System.out.println(object);
    }

    private static String toPipelineName(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("[^A-Za-z0-9-.]", "-");
    }

    private static String toPipelineId(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("[^A-Za-z0-9-]", "-");
    }

    public static void main(String[] args) {
        new CommandLine(new Converter()).execute(args);
    }
}

