/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.core.context.variable;

import java.io.Serializable;
import org.drools.process.core.TypeObject;
import org.drools.process.core.ValueObject;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.UndefinedDataType;

public class Variable
implements TypeObject,
ValueObject,
Serializable {
    private static final long serialVersionUID = 400L;
    private String name;
    private DataType type = UndefinedDataType.getInstance();
    private Object value;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (!this.type.verifyDataType(value)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Value <");
            sb.append(value);
            sb.append("> is not valid for datatype: ");
            sb.append(this.type);
            throw new IllegalArgumentException(sb.toString());
        }
        this.value = value;
    }

    public String toString() {
        return this.name;
    }
}

