/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationList;
import org.milyn.cdr.XMLConfigDigester;
import org.milyn.cdr.annotation.Configurator;
import org.milyn.classpath.ClasspathUtils;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.ContentHandlerFactory;
import org.milyn.delivery.JavaContentHandlerFactory;
import org.milyn.delivery.UnsupportedContentHandlerTypeException;
import org.milyn.delivery.annotation.Resource;
import org.milyn.javabean.DataDecoder;
import org.milyn.profile.ProfileSet;
import org.milyn.profile.ProfileStore;
import org.milyn.resource.ContainerResourceLocator;
import org.milyn.util.ClassUtil;
import org.xml.sax.SAXException;

public class SmooksResourceConfigurationStore {
    private static Log logger = LogFactory.getLog(SmooksResourceConfigurationStore.class);
    private List<SmooksResourceConfigurationList> configLists = new ArrayList<SmooksResourceConfigurationList>();
    private List<Object> initializedObjects = new ArrayList<Object>(){

        @Override
        public boolean add(Object object) {
            if (this.contains(object)) {
                return false;
            }
            return super.add(object);
        }
    };
    private SmooksResourceConfigurationList defaultList = new SmooksResourceConfigurationList("default");
    private ApplicationContext applicationContext;
    private static final String CDU_CREATOR = "cdu-creator";

    public SmooksResourceConfigurationStore(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("null 'applicationContext' arg in constructor call.");
        }
        this.applicationContext = applicationContext;
        this.configLists.add(this.defaultList);
        this.registerInstalledHandlerFactories();
        this.registerInstalledResources("null-dom.cdrl");
        this.registerInstalledResources("null-sax.cdrl");
        this.registerInstalledResources("installed-param-decoders.cdrl");
        this.registerInstalledResources("installed-serializers.cdrl");
    }

    public void removeShutdownHook() {
    }

    private void registerInstalledHandlerFactories() {
        List<Class<ContentHandlerFactory>> handlerFactories = ClassUtil.getClasses("META-INF/content-handlers.inf", ContentHandlerFactory.class);
        for (Class<ContentHandlerFactory> handlerFactory : handlerFactories) {
            Resource resourceAnnotation = handlerFactory.getAnnotation(Resource.class);
            if (resourceAnnotation == null) continue;
            this.addHandlerFactoryConfig(handlerFactory, resourceAnnotation.type());
        }
        this.addHandlerFactoryConfig(JavaContentHandlerFactory.class, "class");
    }

    private void addHandlerFactoryConfig(Class handlerFactory, String type) {
        SmooksResourceConfiguration res = new SmooksResourceConfiguration(CDU_CREATOR);
        res.setTargetProfile("*");
        res.setResource(handlerFactory.getName());
        res.setParameter("restype", type);
        this.defaultList.add(res);
    }

    private void registerInstalledResources(String resourceFile) {
        InputStream resource = ClassUtil.getResourceAsStream(resourceFile, this.getClass());
        if (resource == null) {
            throw new IllegalStateException("Failed to load " + resourceFile + ".  Expected to be in the same package as " + this.getClass().getName());
        }
        try {
            SmooksResourceConfigurationList resourceList = this.registerResources(resourceFile, resource);
            int i = 0;
            while (i < resourceList.size()) {
                resourceList.get(i).setDefaultResource(true);
                ++i;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error processing resource file '" + resourceFile + "'.", e);
        }
    }

    public void load(BufferedReader cdrlLoadList) throws IOException {
        String uri;
        ContainerResourceLocator resLocator = this.applicationContext.getResourceLocator();
        while ((uri = cdrlLoadList.readLine()) != null) {
            if ((uri = uri.trim()).equals("") || uri.charAt(0) == '#') continue;
            try {
                InputStream resource = resLocator.getResource(uri);
                logger.info((Object)("Loading Smooks Resources from uri [" + uri + "]."));
                this.registerResources(uri, resource);
                logger.debug((Object)("[" + uri + "] Loaded."));
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
            catch (SAXException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
            catch (URISyntaxException e) {
                logger.error((Object)("[" + uri + "] Load failure. " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public SmooksResourceConfigurationList registerResources(String baseURI, InputStream resourceConfigStream) throws SAXException, IOException, URISyntaxException {
        if (baseURI == null || baseURI.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'name' arg in method call.");
        }
        if (resourceConfigStream == null) {
            throw new IllegalArgumentException("null 'resourceConfigStream' arg in method call.");
        }
        SmooksResourceConfigurationList configList = XMLConfigDigester.digestConfig(resourceConfigStream, baseURI);
        this.configLists.add(configList);
        this.addProfileSets(configList.getProfiles());
        return configList;
    }

    private void addProfileSets(List<ProfileSet> profileSets) {
        if (profileSets == null) {
            return;
        }
        if (this.applicationContext instanceof ApplicationContext) {
            ProfileStore profileStore = this.applicationContext.getProfileStore();
            for (ProfileSet profileSet : profileSets) {
                profileStore.addProfileSet(profileSet);
            }
        }
    }

    public void registerResource(SmooksResourceConfiguration resourceConfig) {
        if (resourceConfig == null) {
            throw new IllegalArgumentException("null 'resourceConfig' arg in method call.");
        }
        this.defaultList.add(resourceConfig);
    }

    public void addSmooksResourceConfigurationList(SmooksResourceConfigurationList resourceList) {
        this.configLists.add(resourceList);
    }

    public Iterator<SmooksResourceConfigurationList> getSmooksResourceConfigurationLists() {
        return this.configLists.iterator();
    }

    public SmooksResourceConfiguration[] getSmooksResourceConfigurations(ProfileSet profileSet) {
        Vector<SmooksResourceConfiguration> allSmooksResourceConfigurationsColl = new Vector<SmooksResourceConfiguration>();
        int i = 0;
        while (i < this.configLists.size()) {
            SmooksResourceConfigurationList list = this.configLists.get(i);
            SmooksResourceConfiguration[] resourceConfigs = list.getTargetConfigurations(profileSet);
            allSmooksResourceConfigurationsColl.addAll(Arrays.asList(resourceConfigs));
            ++i;
        }
        SmooksResourceConfiguration[] allSmooksResourceConfigurations = new SmooksResourceConfiguration[allSmooksResourceConfigurationsColl.size()];
        allSmooksResourceConfigurationsColl.toArray(allSmooksResourceConfigurations);
        return allSmooksResourceConfigurations;
    }

    public Object getObject(SmooksResourceConfiguration resourceConfig) {
        Class classRuntime;
        Object object = null;
        String className = ClasspathUtils.toClassName(resourceConfig.getResource());
        try {
            classRuntime = ClassUtil.forName(className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            IllegalStateException state = new IllegalStateException("Error loading Java class: " + className);
            state.initCause(e);
            throw state;
        }
        try {
            Constructor constructor = classRuntime.getConstructor(SmooksResourceConfiguration.class);
            object = constructor.newInstance(resourceConfig);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            IllegalStateException state = new IllegalStateException("Error loading Java class: " + className);
            state.initCause(e);
            throw state;
        }
        if (object == null) {
            try {
                object = classRuntime.newInstance();
            }
            catch (Exception e) {
                IllegalStateException state = new IllegalStateException("Java class " + className + " must contain a default constructor if it does not contain a constructor that takes an instance of " + SmooksResourceConfiguration.class.getName() + ".");
                state.initCause(e);
                throw state;
            }
        }
        if (object instanceof ContentHandler || object instanceof DataDecoder) {
            Configurator.configure(object, resourceConfig, this.applicationContext);
            this.initializedObjects.add(object);
        }
        return object;
    }

    public List<Object> getInitializedObjects() {
        return this.initializedObjects;
    }

    public SmooksResourceConfiguration getGlobalParams() {
        SmooksResourceConfiguration config = new SmooksResourceConfiguration();
        int i = 0;
        while (i < this.configLists.size()) {
            SmooksResourceConfigurationList list = this.configLists.get(i);
            int ii = 0;
            while (ii < list.size()) {
                SmooksResourceConfiguration nextConfig = list.get(ii);
                if ("global-parameters".equals(nextConfig.getSelector())) {
                    config.addParmeters(nextConfig);
                }
                ++ii;
            }
            ++i;
        }
        return config;
    }

    public ContentHandlerFactory getContentHandlerFactory(String type) throws UnsupportedContentHandlerTypeException {
        if (type == null) {
            throw new IllegalArgumentException("null 'resourceExtension' arg in method call.");
        }
        int i = 0;
        while (i < this.configLists.size()) {
            SmooksResourceConfigurationList list = this.configLists.get(i);
            int ii = 0;
            while (ii < list.size()) {
                SmooksResourceConfiguration config = list.get(ii);
                String selector = config.getSelector();
                if (CDU_CREATOR.equals(selector) && type.equalsIgnoreCase(config.getStringParameter("restype"))) {
                    return (ContentHandlerFactory)this.getObject(config);
                }
                ++ii;
            }
            ++i;
        }
        throw new UnsupportedContentHandlerTypeException(type);
    }

    public void close() {
        if (this.initializedObjects != null) {
            logger.debug((Object)"Uninitializing all ContentHandler instances allocated through this store.");
            for (Object object : this.initializedObjects) {
                try {
                    logger.debug((Object)("Uninitializing ContentHandler instance: " + object.getClass().getName()));
                    Configurator.uninitialise(object);
                }
                catch (Throwable throwable) {
                    logger.error((Object)("Error uninitializing " + object.getClass().getName() + "."), throwable);
                }
            }
            this.initializedObjects = null;
        }
    }
}

