/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.janino.Java;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.AutoIndentWriter;

public class UnparseVisitor
implements Visitor.ComprehensiveVisitor {
    protected final AutoIndentWriter aiw;
    protected final PrintWriter pw;
    private static final Set LEFT_ASSOCIATIVE_OPERATORS = new HashSet();
    private static final Set RIGHT_ASSOCIATIVE_OPERATORS = new HashSet();
    private static final Set UNARY_OPERATORS = new HashSet();
    private static final Map OPERATOR_PRECEDENCE = new HashMap();

    static {
        Object[] objectArray = new Object[]{RIGHT_ASSOCIATIVE_OPERATORS, "=", "*=", "/=", "%=", "+=", "-=", "<<=", ">>=", ">>>=", "&=", "^=", "|=", RIGHT_ASSOCIATIVE_OPERATORS, "?:", LEFT_ASSOCIATIVE_OPERATORS, "||", LEFT_ASSOCIATIVE_OPERATORS, "&&", LEFT_ASSOCIATIVE_OPERATORS, "|", LEFT_ASSOCIATIVE_OPERATORS, "^", LEFT_ASSOCIATIVE_OPERATORS, "&", LEFT_ASSOCIATIVE_OPERATORS, "==", "!=", LEFT_ASSOCIATIVE_OPERATORS, "<", ">", "<=", ">=", "instanceof", LEFT_ASSOCIATIVE_OPERATORS, "<<", ">>", ">>>", LEFT_ASSOCIATIVE_OPERATORS, "+", "-", LEFT_ASSOCIATIVE_OPERATORS, "*", "/", "%", RIGHT_ASSOCIATIVE_OPERATORS, "cast", UNARY_OPERATORS, "++x", "--x", "+x", "-x", "~x", "!x", UNARY_OPERATORS, "x++", "x--", LEFT_ASSOCIATIVE_OPERATORS, "new", LEFT_ASSOCIATIVE_OPERATORS, ".", "[ ]"};
        int n = 0;
        int n2 = 0;
        block0: while (true) {
            Set set = (Set)objectArray[n2++];
            Integer n3 = new Integer(++n);
            while (n2 != objectArray.length) {
                if (!(objectArray[n2] instanceof String)) continue block0;
                String string = (String)objectArray[n2++];
                set.add(string);
                OPERATOR_PRECEDENCE.put(string, n3);
            }
            break;
        }
    }

    public UnparseVisitor(Writer writer) {
        this.aiw = new AutoIndentWriter(writer);
        this.pw = new PrintWriter((Writer)this.aiw, true);
    }

    private static int comparePrecedence(String string, Java.Atom atom) {
        if (atom instanceof Java.BinaryOperation) {
            return UnparseVisitor.getOperatorPrecedence(string) - UnparseVisitor.getOperatorPrecedence(((Java.BinaryOperation)atom).op);
        }
        if (atom instanceof Java.UnaryOperation) {
            return UnparseVisitor.getOperatorPrecedence(string) - UnparseVisitor.getOperatorPrecedence(String.valueOf(((Java.UnaryOperation)atom).operator) + "x");
        }
        if (atom instanceof Java.ConditionalExpression) {
            return UnparseVisitor.getOperatorPrecedence(string) - UnparseVisitor.getOperatorPrecedence("?:");
        }
        if (atom instanceof Java.Instanceof) {
            return UnparseVisitor.getOperatorPrecedence(string) - UnparseVisitor.getOperatorPrecedence("instanceof");
        }
        if (atom instanceof Java.Cast) {
            return UnparseVisitor.getOperatorPrecedence(string) - UnparseVisitor.getOperatorPrecedence("cast");
        }
        if (atom instanceof Java.MethodInvocation || atom instanceof Java.FieldAccess) {
            return UnparseVisitor.getOperatorPrecedence(string) - UnparseVisitor.getOperatorPrecedence(".");
        }
        if (atom instanceof Java.NewArray) {
            return UnparseVisitor.getOperatorPrecedence(string) - UnparseVisitor.getOperatorPrecedence("new");
        }
        if (atom instanceof Java.Crement) {
            Java.Crement crement = (Java.Crement)atom;
            return UnparseVisitor.getOperatorPrecedence(string) - UnparseVisitor.getOperatorPrecedence(crement.pre ? String.valueOf(crement.operator) + "x" : "x" + crement.operator);
        }
        return -1;
    }

    private static final int getOperatorPrecedence(String string) {
        return (Integer)OPERATOR_PRECEDENCE.get(string);
    }

    private static boolean isLeftAssociate(String string) {
        return LEFT_ASSOCIATIVE_OPERATORS.contains(string);
    }

    private static boolean isRightAssociate(String string) {
        return RIGHT_ASSOCIATIVE_OPERATORS.contains(string);
    }

    public static void main(String[] stringArray) throws Exception {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        int n = 0;
        while (n < stringArray.length) {
            Java.CompilationUnit compilationUnit;
            String string = stringArray[n];
            FileReader fileReader = new FileReader(string);
            try {
                compilationUnit = new Parser(new Scanner(string, fileReader)).parseCompilationUnit();
            }
            finally {
                Object var7_6 = null;
                fileReader.close();
            }
            UnparseVisitor.unparse(compilationUnit, bufferedWriter);
            ++n;
        }
        ((Writer)bufferedWriter).flush();
    }

    private void unparse(Java.Atom atom) {
        atom.accept(this);
    }

    private void unparse(Java.Atom atom, boolean bl) {
        if (!bl) {
            this.pw.print("((( ");
        }
        this.unparse(atom);
        if (!bl) {
            this.pw.print(" )))");
        }
    }

    public static void unparse(Java.CompilationUnit compilationUnit, Writer writer) {
        new UnparseVisitor(writer).unparseCompilationUnit(compilationUnit);
    }

    private void unparseAbstractTypeDeclarationBody(Java.AbstractTypeDeclaration abstractTypeDeclaration) {
        Iterator iterator = abstractTypeDeclaration.declaredMethods.iterator();
        while (iterator.hasNext()) {
            ((Java.MethodDeclarator)iterator.next()).accept(this);
            this.pw.println();
        }
        Iterator iterator2 = abstractTypeDeclaration.declaredClassesAndInterfaces.iterator();
        while (iterator2.hasNext()) {
            ((Java.TypeBodyDeclaration)iterator2.next()).accept(this);
            this.pw.println();
        }
    }

    private void unparseArrayInitializerOrRvalue(Java.ArrayInitializerOrRvalue arrayInitializerOrRvalue) {
        if (arrayInitializerOrRvalue instanceof Java.Rvalue) {
            this.unparse((Java.Rvalue)arrayInitializerOrRvalue);
        } else if (arrayInitializerOrRvalue instanceof Java.ArrayInitializer) {
            Java.ArrayInitializer arrayInitializer = (Java.ArrayInitializer)arrayInitializerOrRvalue;
            if (arrayInitializer.values.length == 0) {
                this.pw.print("{}");
            } else {
                this.pw.print("{ ");
                this.unparseArrayInitializerOrRvalue(arrayInitializer.values[0]);
                int n = 1;
                while (n < arrayInitializer.values.length) {
                    this.pw.print(", ");
                    this.unparseArrayInitializerOrRvalue(arrayInitializer.values[n]);
                    ++n;
                }
                this.pw.print(" }");
            }
        } else {
            throw new RuntimeException("Unexpected array initializer or rvalue class " + arrayInitializerOrRvalue.getClass().getName());
        }
    }

    private void unparseBlockStatement(Java.BlockStatement blockStatement) {
        blockStatement.accept(this);
    }

    private void unparseClassDeclarationBody(Java.ClassDeclaration classDeclaration) {
        Iterator iterator = classDeclaration.constructors.iterator();
        while (iterator.hasNext()) {
            ((Java.ConstructorDeclarator)iterator.next()).accept(this);
            this.pw.println();
        }
        this.unparseAbstractTypeDeclarationBody(classDeclaration);
        Iterator iterator2 = classDeclaration.variableDeclaratorsAndInitializers.iterator();
        while (iterator2.hasNext()) {
            ((Java.TypeBodyDeclaration)iterator2.next()).accept(this);
            this.pw.println();
        }
    }

    public void unparseCompilationUnit(Java.CompilationUnit compilationUnit) {
        if (compilationUnit.optionalPackageDeclaration != null) {
            this.pw.println("package " + compilationUnit.optionalPackageDeclaration.packageName + ';');
        }
        Iterator iterator = compilationUnit.importDeclarations.iterator();
        while (iterator.hasNext()) {
            ((Java.CompilationUnit.ImportDeclaration)iterator.next()).accept(this);
        }
        Iterator iterator2 = compilationUnit.packageMemberTypeDeclarations.iterator();
        while (iterator2.hasNext()) {
            this.unparseTypeDeclaration((Java.PackageMemberTypeDeclaration)iterator2.next());
            this.pw.println();
        }
    }

    private void unparseDocComment(Java.DocCommentable docCommentable) {
        String string = docCommentable.getDocComment();
        if (string != null) {
            this.pw.println();
            this.pw.print("/**");
            this.aiw.setPrefix(" *");
            try {
                this.pw.print(string);
            }
            finally {
                Object var4_3 = null;
                this.aiw.setPrefix(null);
            }
            this.pw.println("*/");
        }
    }

    public void unparseFormalParameter(Java.FunctionDeclarator.FormalParameter formalParameter) {
        if (formalParameter.finaL) {
            this.pw.print("final ");
        }
        this.unparseType(formalParameter.type);
        this.pw.print(String.valueOf(' ') + formalParameter.name);
    }

    private void unparseFunctionDeclaratorRest(Java.FunctionDeclarator functionDeclarator) {
        this.pw.print('(');
        int n = 0;
        while (n < functionDeclarator.formalParameters.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            this.unparseFormalParameter(functionDeclarator.formalParameters[n]);
            ++n;
        }
        this.pw.print(')');
        if (functionDeclarator.thrownExceptions.length > 0) {
            this.pw.print(" throws " + Java.join(functionDeclarator.thrownExceptions, ", "));
        }
    }

    private void unparseFunctionInvocationArguments(Java.Rvalue[] rvalueArray) {
        this.pw.print('(');
        int n = 0;
        while (n < rvalueArray.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            this.unparse(rvalueArray[n]);
            ++n;
        }
        this.pw.print(')');
    }

    private void unparseInterfaceDeclaration(Java.InterfaceDeclaration interfaceDeclaration) {
        this.unparseDocComment(interfaceDeclaration);
        this.unparseModifiers(interfaceDeclaration.modifiers);
        this.pw.print("interface " + interfaceDeclaration.name);
        if (interfaceDeclaration.extendedTypes.length > 0) {
            this.pw.print(" extends " + Java.join(interfaceDeclaration.extendedTypes, ", "));
        }
        this.pw.println(" {");
        this.unparseAbstractTypeDeclarationBody(interfaceDeclaration);
        Iterator iterator = interfaceDeclaration.constantDeclarations.iterator();
        while (iterator.hasNext()) {
            ((Java.TypeBodyDeclaration)iterator.next()).accept(this);
            this.pw.println();
        }
        this.pw.print('}');
    }

    private void unparseLhs(Java.Atom atom, String string) {
        int n = UnparseVisitor.comparePrecedence(string, atom);
        this.unparse(atom, n < 0 || n == 0 && UnparseVisitor.isLeftAssociate(string));
    }

    private void unparseModifiers(short s) {
        if (s != 0) {
            this.pw.print(String.valueOf(Mod.shortToString(s)) + ' ');
        }
    }

    private void unparseNamedClassDeclaration(Java.NamedClassDeclaration namedClassDeclaration) {
        this.unparseDocComment(namedClassDeclaration);
        this.unparseModifiers(namedClassDeclaration.modifiers);
        this.pw.print("class " + namedClassDeclaration.name);
        if (namedClassDeclaration.optionalExtendedType != null) {
            this.pw.print(" extends ");
            this.unparseType(namedClassDeclaration.optionalExtendedType);
        }
        if (namedClassDeclaration.implementedTypes.length > 0) {
            this.pw.print(" implements " + Java.join(namedClassDeclaration.implementedTypes, ", "));
        }
        this.pw.println(" {");
        this.unparseClassDeclarationBody(namedClassDeclaration);
        this.pw.print('}');
    }

    private void unparseRhs(Java.Rvalue rvalue, String string) {
        int n = UnparseVisitor.comparePrecedence(string, rvalue);
        this.unparse(rvalue, n < 0 || n == 0 && UnparseVisitor.isRightAssociate(string));
    }

    private void unparseType(Java.Type type) {
        type.accept(this);
    }

    private void unparseTypeDeclaration(Java.TypeDeclaration typeDeclaration) {
        typeDeclaration.accept(this);
    }

    private void unparseUnaryOperation(Java.Rvalue rvalue, String string) {
        int n = UnparseVisitor.comparePrecedence(string, rvalue);
        this.unparse(rvalue, n < 0);
    }

    public void unparseVariableDeclarator(Java.VariableDeclarator variableDeclarator) {
        this.pw.print(variableDeclarator.name);
        int n = 0;
        while (n < variableDeclarator.brackets) {
            this.pw.print("[]");
            ++n;
        }
        if (variableDeclarator.optionalInitializer != null) {
            this.pw.print(" = ");
            this.unparseArrayInitializerOrRvalue(variableDeclarator.optionalInitializer);
        }
    }

    public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation alternateConstructorInvocation) {
        this.pw.print("this");
        this.unparseFunctionInvocationArguments(alternateConstructorInvocation.arguments);
    }

    public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
        this.pw.print(ambiguousName.toString());
    }

    public void visitAnonymousClassDeclaration(Java.AnonymousClassDeclaration anonymousClassDeclaration) {
        this.unparseType(anonymousClassDeclaration.baseType);
        this.pw.println(" {");
        this.unparseClassDeclarationBody(anonymousClassDeclaration);
        this.pw.print('}');
    }

    public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
        this.unparseLhs(arrayAccessExpression.lhs, "[ ]");
        this.pw.print('[');
        this.unparse(arrayAccessExpression.index);
        this.pw.print(']');
    }

    public void visitArrayLength(Java.ArrayLength arrayLength) {
        this.unparseLhs(arrayLength.lhs, ".");
        this.pw.print(".length");
    }

    public void visitArrayType(Java.ArrayType arrayType) {
        this.unparseType(arrayType.componentType);
        this.pw.print("[]");
    }

    public void visitAssignment(Java.Assignment assignment) {
        this.unparseLhs(assignment.lhs, assignment.operator);
        this.pw.print(String.valueOf(' ') + assignment.operator + ' ');
        this.unparseRhs(assignment.rhs, assignment.operator);
    }

    public void visitBasicType(Java.BasicType basicType) {
        this.pw.print(basicType.toString());
    }

    public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
        this.unparseLhs(binaryOperation.lhs, binaryOperation.op);
        this.pw.print(String.valueOf(' ') + binaryOperation.op + ' ');
        this.unparseRhs(binaryOperation.rhs, binaryOperation.op);
    }

    public void visitBlock(Java.Block block) {
        this.pw.println('{');
        Iterator iterator = block.statements.iterator();
        while (iterator.hasNext()) {
            this.unparseBlockStatement((Java.BlockStatement)iterator.next());
            this.pw.println();
        }
        this.pw.print('}');
    }

    public void visitBreakStatement(Java.BreakStatement breakStatement) {
        this.pw.print("break");
        if (breakStatement.optionalLabel != null) {
            this.pw.print(String.valueOf(' ') + breakStatement.optionalLabel);
        }
        this.pw.print(';');
    }

    public void visitCast(Java.Cast cast) {
        this.pw.print('(');
        this.unparseType(cast.targetType);
        this.pw.print(") ");
        this.unparseRhs(cast.value, "cast");
    }

    public void visitClassLiteral(Java.ClassLiteral classLiteral) {
        this.unparseType(classLiteral.type);
        this.pw.print(".class");
    }

    public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
        this.unparseLhs(conditionalExpression.lhs, "?:");
        this.pw.print(" ? ");
        this.unparseLhs(conditionalExpression.mhs, "?:");
        this.pw.print(" : ");
        this.unparseRhs(conditionalExpression.rhs, "?:");
    }

    public void visitConstructorDeclarator(Java.ConstructorDeclarator constructorDeclarator) {
        this.unparseDocComment(constructorDeclarator);
        this.unparseModifiers(constructorDeclarator.modifiers);
        Java.ClassDeclaration classDeclaration = constructorDeclarator.getDeclaringClass();
        this.pw.print(classDeclaration instanceof Java.NamedClassDeclaration ? ((Java.NamedClassDeclaration)classDeclaration).name : "UNNAMED");
        this.unparseFunctionDeclaratorRest(constructorDeclarator);
        this.pw.print(' ');
        if (constructorDeclarator.optionalConstructorInvocation != null) {
            this.pw.println('{');
            this.unparseBlockStatement(constructorDeclarator.optionalConstructorInvocation);
            this.pw.println(';');
            Iterator iterator = constructorDeclarator.optionalBody.statements.iterator();
            while (iterator.hasNext()) {
                this.unparseBlockStatement((Java.BlockStatement)iterator.next());
                this.pw.println();
            }
            this.pw.print('}');
        } else {
            this.unparseBlockStatement(constructorDeclarator.optionalBody);
        }
    }

    public void visitContinueStatement(Java.ContinueStatement continueStatement) {
        this.pw.print("continue");
        if (continueStatement.optionalLabel != null) {
            this.pw.print(String.valueOf(' ') + continueStatement.optionalLabel);
        }
        this.pw.print(';');
    }

    public void visitCrement(Java.Crement crement) {
        if (crement.pre) {
            this.pw.print(crement.operator);
            this.unparseUnaryOperation(crement.operand, String.valueOf(crement.operator) + "x");
        } else {
            this.unparseUnaryOperation(crement.operand, "x" + crement.operator);
            this.pw.print(crement.operator);
        }
    }

    public void visitDoStatement(Java.DoStatement doStatement) {
        this.pw.print("do ");
        this.unparseBlockStatement(doStatement.body);
        this.pw.print("while (");
        this.unparse(doStatement.condition);
        this.pw.print(");");
    }

    public void visitEmptyStatement(Java.EmptyStatement emptyStatement) {
        this.pw.print(';');
    }

    public void visitExpressionStatement(Java.ExpressionStatement expressionStatement) {
        this.unparse(expressionStatement.rvalue);
        this.pw.print(';');
    }

    public void visitFieldAccess(Java.FieldAccess fieldAccess) {
        this.unparseLhs(fieldAccess.lhs, ".");
        this.pw.print(String.valueOf('.') + fieldAccess.field.getName());
    }

    public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
        this.unparseLhs(fieldAccessExpression.lhs, ".");
        this.pw.print(String.valueOf('.') + fieldAccessExpression.fieldName);
    }

    public void visitFieldDeclaration(Java.FieldDeclaration fieldDeclaration) {
        this.unparseDocComment(fieldDeclaration);
        this.unparseModifiers(fieldDeclaration.modifiers);
        this.unparseType(fieldDeclaration.type);
        this.pw.print(' ');
        int n = 0;
        while (n < fieldDeclaration.variableDeclarators.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            this.unparseVariableDeclarator(fieldDeclaration.variableDeclarators[n]);
            ++n;
        }
        this.pw.print(';');
    }

    public void visitForStatement(Java.ForStatement forStatement) {
        this.pw.print("for (");
        if (forStatement.optionalInit != null) {
            this.unparseBlockStatement(forStatement.optionalInit);
        } else {
            this.pw.print(';');
        }
        if (forStatement.optionalCondition != null) {
            this.pw.print(' ');
            this.unparse(forStatement.optionalCondition);
        }
        this.pw.print(';');
        if (forStatement.optionalUpdate != null) {
            this.pw.print(' ');
            int n = 0;
            while (n < forStatement.optionalUpdate.length) {
                if (n > 0) {
                    this.pw.print(", ");
                }
                this.unparse(forStatement.optionalUpdate[n]);
                ++n;
            }
        }
        this.pw.print(") ");
        this.unparseBlockStatement(forStatement.body);
    }

    public void visitIfStatement(Java.IfStatement ifStatement) {
        this.pw.print("if (");
        this.unparse(ifStatement.condition);
        this.pw.print(") ");
        this.unparseBlockStatement(ifStatement.thenStatement);
        if (ifStatement.optionalElseStatement != null) {
            this.pw.print(" else ");
            this.unparseBlockStatement(ifStatement.optionalElseStatement);
        }
    }

    public void visitInitializer(Java.Initializer initializer) {
        if (initializer.statiC) {
            this.pw.print("static ");
        }
        this.unparseBlockStatement(initializer.block);
    }

    public void visitInstanceof(Java.Instanceof instanceof_) {
        this.unparseLhs(instanceof_.lhs, "instanceof");
        this.pw.print(" instanceof ");
        this.unparseType(instanceof_.rhs);
    }

    public void visitLabeledStatement(Java.LabeledStatement labeledStatement) {
        this.pw.println(String.valueOf(labeledStatement.label) + ':');
        this.unparseBlockStatement(labeledStatement.body);
    }

    public void visitLiteral(Java.Literal literal) {
        this.pw.print(literal.toString());
    }

    public void visitLocalClassDeclaration(Java.LocalClassDeclaration localClassDeclaration) {
        this.unparseNamedClassDeclaration(localClassDeclaration);
    }

    public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement localClassDeclarationStatement) {
        this.unparseTypeDeclaration(localClassDeclarationStatement.lcd);
    }

    public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
        this.pw.print(localVariableAccess.toString());
    }

    public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement localVariableDeclarationStatement) {
        this.unparseModifiers(localVariableDeclarationStatement.modifiers);
        this.unparseType(localVariableDeclarationStatement.type);
        this.pw.print(' ');
        this.unparseVariableDeclarator(localVariableDeclarationStatement.variableDeclarators[0]);
        int n = 1;
        while (n < localVariableDeclarationStatement.variableDeclarators.length) {
            this.pw.print(", ");
            this.unparseVariableDeclarator(localVariableDeclarationStatement.variableDeclarators[n]);
            ++n;
        }
        this.pw.print(';');
    }

    public void visitMemberClassDeclaration(Java.MemberClassDeclaration memberClassDeclaration) {
        this.unparseNamedClassDeclaration(memberClassDeclaration);
    }

    public void visitMemberInterfaceDeclaration(Java.MemberInterfaceDeclaration memberInterfaceDeclaration) {
        this.unparseInterfaceDeclaration(memberInterfaceDeclaration);
    }

    public void visitMethodDeclarator(Java.MethodDeclarator methodDeclarator) {
        this.unparseDocComment(methodDeclarator);
        this.unparseModifiers(methodDeclarator.modifiers);
        this.unparseType(methodDeclarator.type);
        this.pw.print(String.valueOf(' ') + methodDeclarator.name);
        this.unparseFunctionDeclaratorRest(methodDeclarator);
        if (methodDeclarator.optionalBody != null) {
            this.pw.print(' ');
            this.unparseBlockStatement(methodDeclarator.optionalBody);
        } else {
            this.pw.print(';');
        }
    }

    public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
        if (methodInvocation.optionalTarget != null) {
            this.unparseLhs(methodInvocation.optionalTarget, ".");
            this.pw.print('.');
        }
        this.pw.print(methodInvocation.methodName);
        this.unparseFunctionInvocationArguments(methodInvocation.arguments);
    }

    public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
        if (newAnonymousClassInstance.optionalQualification != null) {
            this.unparseLhs(newAnonymousClassInstance.optionalQualification, ".");
            this.pw.print('.');
        }
        this.pw.print("new " + newAnonymousClassInstance.anonymousClassDeclaration.baseType.toString() + '(');
        int n = 0;
        while (n < newAnonymousClassInstance.arguments.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            this.unparse(newAnonymousClassInstance.arguments[n]);
            ++n;
        }
        this.pw.println(") {");
        this.unparseClassDeclarationBody(newAnonymousClassInstance.anonymousClassDeclaration);
        this.pw.print('}');
    }

    public void visitNewArray(Java.NewArray newArray) {
        this.pw.print("new ");
        this.unparseType(newArray.type);
        int n = 0;
        while (n < newArray.dimExprs.length) {
            this.pw.print('[');
            this.unparse(newArray.dimExprs[n]);
            this.pw.print(']');
            ++n;
        }
        int n2 = 0;
        while (n2 < newArray.dims) {
            this.pw.print("[]");
            ++n2;
        }
    }

    public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
        if (newClassInstance.optionalQualification != null) {
            this.unparseLhs(newClassInstance.optionalQualification, ".");
            this.pw.print('.');
        }
        this.pw.print("new " + newClassInstance.type.toString());
        this.unparseFunctionInvocationArguments(newClassInstance.arguments);
    }

    public void visitNewInitializedArray(Java.NewInitializedArray newInitializedArray) {
        this.pw.print("new ");
        this.unparseType(newInitializedArray.arrayType);
        this.pw.print(" ");
        this.unparseArrayInitializerOrRvalue(newInitializedArray.arrayInitializer);
    }

    public void visitPackage(Java.Package package_) {
        this.pw.print(package_.toString());
    }

    public void visitPackageMemberClassDeclaration(Java.PackageMemberClassDeclaration packageMemberClassDeclaration) {
        this.unparseNamedClassDeclaration(packageMemberClassDeclaration);
    }

    public void visitPackageMemberInterfaceDeclaration(Java.PackageMemberInterfaceDeclaration packageMemberInterfaceDeclaration) {
        this.unparseInterfaceDeclaration(packageMemberInterfaceDeclaration);
    }

    public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
        this.pw.print(parameterAccess.toString());
    }

    public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
        this.pw.print('(');
        this.unparse(parenthesizedExpression.value);
        this.pw.print(')');
    }

    public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
        this.unparseType(qualifiedThisReference.qualification);
        this.pw.print(".this");
    }

    public void visitReferenceType(Java.ReferenceType referenceType) {
        this.pw.print(referenceType.toString());
    }

    public void visitReturnStatement(Java.ReturnStatement returnStatement) {
        this.pw.print("return");
        if (returnStatement.optionalReturnValue != null) {
            this.pw.print(' ');
            this.unparse(returnStatement.optionalReturnValue);
        }
        this.pw.print(';');
    }

    public void visitRvalueMemberType(Java.RvalueMemberType rvalueMemberType) {
        this.pw.print(rvalueMemberType.toString());
    }

    public void visitSimpleType(Java.SimpleType simpleType) {
        this.pw.print(simpleType.toString());
    }

    public void visitSingleStaticImportDeclaration(Java.CompilationUnit.SingleStaticImportDeclaration singleStaticImportDeclaration) {
        this.pw.println("import static " + Java.join(singleStaticImportDeclaration.identifiers, ".") + ';');
    }

    public void visitSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration singleTypeImportDeclaration) {
        this.pw.println("import " + Java.join(singleTypeImportDeclaration.identifiers, ".") + ';');
    }

    public void visitStaticImportOnDemandDeclaration(Java.CompilationUnit.StaticImportOnDemandDeclaration staticImportOnDemandDeclaration) {
        this.pw.println("import static " + Java.join(staticImportOnDemandDeclaration.identifiers, ".") + ".*;");
    }

    public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation superConstructorInvocation) {
        if (superConstructorInvocation.optionalQualification != null) {
            this.unparseLhs(superConstructorInvocation.optionalQualification, ".");
            this.pw.print('.');
        }
        this.pw.print("super");
        this.unparseFunctionInvocationArguments(superConstructorInvocation.arguments);
    }

    public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression superclassFieldAccessExpression) {
        if (superclassFieldAccessExpression.optionalQualification != null) {
            this.unparseType(superclassFieldAccessExpression.optionalQualification);
            this.pw.print(".super." + superclassFieldAccessExpression.fieldName);
        } else {
            this.pw.print("super." + superclassFieldAccessExpression.fieldName);
        }
    }

    public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
        this.pw.print("super." + superclassMethodInvocation.methodName);
        this.unparseFunctionInvocationArguments(superclassMethodInvocation.arguments);
    }

    public void visitSwitchStatement(Java.SwitchStatement switchStatement) {
        this.pw.print("switch (");
        this.unparse(switchStatement.condition);
        this.pw.println(") {");
        Iterator iterator = switchStatement.sbsgs.iterator();
        while (iterator.hasNext()) {
            Object var5_6;
            Java.SwitchStatement.SwitchBlockStatementGroup switchBlockStatementGroup;
            block5: {
                switchBlockStatementGroup = (Java.SwitchStatement.SwitchBlockStatementGroup)iterator.next();
                this.aiw.unindent();
                try {
                    Iterator iterator2 = switchBlockStatementGroup.caseLabels.iterator();
                    while (iterator2.hasNext()) {
                        Java.Rvalue rvalue = (Java.Rvalue)iterator2.next();
                        this.pw.print("case ");
                        this.unparse(rvalue);
                        this.pw.println(':');
                    }
                    if (!switchBlockStatementGroup.hasDefaultLabel) break block5;
                    this.pw.println("default:");
                }
                catch (Throwable throwable) {
                    var5_6 = null;
                    this.aiw.indent();
                    throw throwable;
                }
            }
            var5_6 = null;
            this.aiw.indent();
            Iterator iterator3 = switchBlockStatementGroup.blockStatements.iterator();
            while (iterator3.hasNext()) {
                this.unparseBlockStatement((Java.BlockStatement)iterator3.next());
                this.pw.println();
            }
        }
        this.pw.print('}');
    }

    public void visitSynchronizedStatement(Java.SynchronizedStatement synchronizedStatement) {
        this.pw.print("synchronized (");
        this.unparse(synchronizedStatement.expression);
        this.pw.print(") ");
        this.unparseBlockStatement(synchronizedStatement.body);
    }

    public void visitThisReference(Java.ThisReference thisReference) {
        this.pw.print("this");
    }

    public void visitThrowStatement(Java.ThrowStatement throwStatement) {
        this.pw.print("throw ");
        this.unparse(throwStatement.expression);
        this.pw.print(';');
    }

    public void visitTryStatement(Java.TryStatement tryStatement) {
        this.pw.print("try ");
        this.unparseBlockStatement(tryStatement.body);
        Iterator iterator = tryStatement.catchClauses.iterator();
        while (iterator.hasNext()) {
            Java.CatchClause catchClause = (Java.CatchClause)iterator.next();
            this.pw.print(" catch (");
            this.unparseFormalParameter(catchClause.caughtException);
            this.pw.print(") ");
            this.unparseBlockStatement(catchClause.body);
        }
        if (tryStatement.optionalFinally != null) {
            this.pw.print(" finally ");
            this.unparseBlockStatement(tryStatement.optionalFinally);
        }
    }

    public void visitTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration typeImportOnDemandDeclaration) {
        this.pw.println("import " + Java.join(typeImportOnDemandDeclaration.identifiers, ".") + ".*;");
    }

    public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
        this.pw.print(unaryOperation.operator);
        this.unparseUnaryOperation(unaryOperation.operand, String.valueOf(unaryOperation.operator) + "x");
    }

    public void visitWhileStatement(Java.WhileStatement whileStatement) {
        this.pw.print("while (");
        this.unparse(whileStatement.condition);
        this.pw.print(") ");
        this.unparseBlockStatement(whileStatement.body);
    }
}

