/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.RemoteCacheException;

public class RMISynchronousCacheReplicator
implements CacheReplicator {
    private static final Logger LOG = Logger.getLogger(RMISynchronousCacheReplicator.class.getName());
    protected Status status;
    protected final boolean replicatePuts;
    protected boolean replicatePutsViaCopy;
    protected final boolean replicateUpdates;
    protected final boolean replicateUpdatesViaCopy;
    protected final boolean replicateRemovals;

    public RMISynchronousCacheReplicator(boolean replicatePuts, boolean replicatePutsViaCopy, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals) {
        this.replicatePuts = replicatePuts;
        this.replicatePutsViaCopy = replicatePutsViaCopy;
        this.replicateUpdates = replicateUpdates;
        this.replicateUpdatesViaCopy = replicateUpdatesViaCopy;
        this.replicateRemovals = replicateRemovals;
        this.status = Status.STATUS_ALIVE;
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicatePuts) {
            return;
        }
        if (!element.isSerializable()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Object with key " + element.getObjectKey() + " is not Serializable and cannot be replicated");
            }
            return;
        }
        if (this.replicatePutsViaCopy) {
            RMISynchronousCacheReplicator.replicatePutNotification(cache, element);
        } else {
            RMISynchronousCacheReplicator.replicateRemovalNotification(cache, (Serializable)element.getObjectKey());
        }
    }

    protected static void replicatePutNotification(Ehcache cache, Element element) throws RemoteCacheException {
        List cachePeers = RMISynchronousCacheReplicator.listRemoteCachePeers(cache);
        for (Object cachePeer1 : cachePeers) {
            CachePeer cachePeer = (CachePeer)cachePeer1;
            try {
                cachePeer.put(element);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Exception on replication of putNotification. " + t.getMessage() + ". Continuing...", t);
            }
        }
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateUpdates) {
            return;
        }
        if (this.replicateUpdatesViaCopy) {
            if (!element.isSerializable()) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Object with key " + element.getObjectKey() + " is not Serializable and cannot be updated via copy");
                }
                return;
            }
            RMISynchronousCacheReplicator.replicatePutNotification(cache, element);
        } else {
            if (!element.isKeySerializable()) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Key " + element.getObjectKey() + " is not Serializable and cannot be replicated.");
                }
                return;
            }
            RMISynchronousCacheReplicator.replicateRemovalNotification(cache, (Serializable)element.getObjectKey());
        }
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        if (!element.isKeySerializable()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Key " + element.getObjectKey() + " is not Serializable and cannot be replicated.");
            }
            return;
        }
        RMISynchronousCacheReplicator.replicateRemovalNotification(cache, (Serializable)element.getObjectKey());
    }

    protected static void replicateRemovalNotification(Ehcache cache, Serializable key) throws RemoteCacheException {
        List cachePeers = RMISynchronousCacheReplicator.listRemoteCachePeers(cache);
        for (Object cachePeer1 : cachePeers) {
            CachePeer cachePeer = (CachePeer)cachePeer1;
            try {
                cachePeer.remove(key);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Exception on replication of removeNotification. " + t.getMessage() + ". Continuing...", t);
            }
        }
    }

    public final void notifyElementExpired(Ehcache cache, Element element) {
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        this.replicateRemoveAllNotification(cache);
    }

    protected void replicateRemoveAllNotification(Ehcache cache) {
        List cachePeers = RMISynchronousCacheReplicator.listRemoteCachePeers(cache);
        for (Object cachePeer1 : cachePeers) {
            CachePeer cachePeer = (CachePeer)cachePeer1;
            try {
                cachePeer.removeAll();
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Exception on replication of removeAllNotification. " + t.getMessage() + ". Continuing...", t);
            }
        }
    }

    static List listRemoteCachePeers(Ehcache cache) {
        CacheManagerPeerProvider provider = cache.getCacheManager().getCacheManagerPeerProvider("RMI");
        return provider.listRemoteCachePeers(cache);
    }

    public final boolean isReplicateUpdatesViaCopy() {
        return this.replicateUpdatesViaCopy;
    }

    public final boolean notAlive() {
        return !this.alive();
    }

    public final boolean alive() {
        if (this.status == null) {
            return false;
        }
        return this.status.equals(Status.STATUS_ALIVE);
    }

    public void dispose() {
        this.status = Status.STATUS_SHUTDOWN;
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        return new RMISynchronousCacheReplicator(this.replicatePuts, this.replicatePutsViaCopy, this.replicateUpdates, this.replicateUpdatesViaCopy, this.replicateRemovals);
    }
}

