/**
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.guvnor.client.explorer;

import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.core.client.GWT;
import com.gwtext.client.widgets.tree.TreePanel;
import org.drools.guvnor.client.messages.Constants;

/**
 * @author Anton Arhipov
 */
public class QAPanel extends GenericPanel {
    private static Constants constants = ((Constants) GWT.create(Constants.class));

    public QAPanel(ExplorerViewCenterPanel tabbedPanel) {

        super(constants.QA1(), tabbedPanel);
        setIconCls("nav-qa"); //NON-NLS

        final VerticalPanel qaPanel = new VerticalPanel();
        qaPanel.setWidth("100%");
        TreePanel qaTree = genericExplorerWidget(ExplorerNodeConfig.getQAStructure(centertabbedPanel));
        qaTree.setRootVisible(false);
        qaPanel.add(PackagesPanel.wrapScroll(qaTree));
        
        add(qaPanel);
    }

}
