package com.redhat.installer.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;

/**
 * @author Jyoti Tripathi
 */
public class DomainPortOffsetAction implements PanelAction  {

    /**
     * @param handler Note, as per spec., if there isn't a GUI, handler is null
     */
    public void executeAction(final AutomatedInstallData idata, AbstractUIHandler handler)  { // OFFSET
       int offset = Integer.parseInt(idata.getVariable("domain.port-offset"));
       idata.setVariable("domain.port-offset150", offset+150+"");
       idata.setVariable("domain.port-offset250", offset+250+"");       
       /** Port number for domain master is the same as the management native port */
       String domainNative = idata.getVariable("domain.management-native");
       String domainHttp = idata.getVariable("domain.management-http");

       int domainNativeNum = getPort(domainNative);
       int domainHttpNum = getPort(domainHttp);
       idata.setVariable("domain.management-native", "${"+idata.getVariable("domain.management-native-1")+":"+ (domainNativeNum + offset) + "}");
       idata.setVariable("domain.management-http", "${"+idata.getVariable("domain.management-http-1")+":"+ (domainHttpNum + offset) + "}");
       idata.setVariable("master.domain.port", "${"+idata.getVariable("domain.management-native-1")+":"+ (domainNativeNum + offset) + "}");  
    }

    /**
     * There shouldn't be any need for configuration, since this is a dedicated class
     * @param configuration null if no configuration block for the action
     */
    public void initialize(PanelActionConfiguration configuration) {
    }
    
    /** Get the appropriate port number from the port configuration panels
     * 
     * @param variable
     * @return
     */
    private int getPort(String variable) 
    {
    	if (variable != null && variable.startsWith("${")
            && variable.contains(":") && variable.endsWith("}"))
       {
	        String testValue = variable.substring(2, variable.length() - 1);
	        String[] split = testValue.split(":");
	        return Integer.parseInt(split[1]);
	    }
    	else
    	{
    		return Integer.parseInt(variable);
    	}
    }
}
