package com.redhat.installer.postinstall;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;

import java.io.File;
import java.io.IOException;

/**
 * Trivial class to create an empty file. Useful for creating / manipulating .dodeploy files
 * Created by thauser on 12/13/13.
 */
public class EmptyFileCreator {

    public static void run(AbstractUIProcessHandler handler, String[]args){
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        for (String file : args){
            File emptyFile = new File(file);
            if (!emptyFile.exists()){
                try {
                emptyFile.createNewFile();
                ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("EmptyFileCreator.creation"),file), false);
                } catch (IOException ioe){
                    ioe.printStackTrace();
                    ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("EmptyFileCreator.creationfailed"), file), true);
                }
            } else {
                ProcessPanelHelper.printToPanel(handler, String.format(idata.langpack.getString("EmptyFileCreator.existing"),file), false);
            }

        }
    }
}
