package com.redhat.installer.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.redhat.installer.util.KeystoreUtils;

public class SSLKeystoreValidator implements DataValidator {
	
	private String error;

	@Override
	public Status validateData(AutomatedInstallData idata) {
		String keystoreLoc = idata.getVariable("ssl.path"); // keystore path, URL or what have you
		char[] pwd = idata.getVariable("ssl.password").toCharArray();
		int result = KeystoreUtils.isValidKeystore(keystoreLoc, pwd); 
		if (result == 0){
			return Status.OK;
		} else {
			setError(idata.langpack.getString("ssl.password.incorrect"));
			return Status.WARNING;
		}
	}

	private void setError(String s) {
		error = s;
	}

	@Override
	public String getErrorMessageId() {
		return error;
	}

	@Override
	public String getWarningMessageId() {
		return error;
	}

	@Override
	public boolean getDefaultAnswer() {
		return false;
	}
}
