package com.redhat.installer.tests;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.util.ValidatorConstants;
import org.apache.commons.io.FileUtils;
import org.junit.*;

import java.lang.reflect.Method;
import java.util.List;

/**
 * Created by thauser on 2/4/14.
 */
public abstract class ProcessPanelTester {
    public AbstractUIProcessHandler handler = new MockAbstractUIProcessHandler();
    public static AutomatedInstallData idata;

    @BeforeClass
    public static void initial() throws Exception {
        idata = new AutomatedInstallData();
    }

    @AfterClass
    public static void destroy() throws Exception{
        FileUtils.deleteDirectory(TestUtils.INSTALL_PATH_FILE);
        TestUtils.destroyIdataSingleton();
        idata = null;
    }

    @Before
    public void start() throws Exception {
        handler = new MockAbstractUIProcessHandler();
        idata.setVariable("INSTALL_PATH", TestUtils.INSTALL_PATH);
        idata.setVariable("INSTALL_SUBPATH", TestUtils.INSTALL_SUBPATH);
        idata.setVariable("installation.logfile", TestUtils.testLogFilename);
        idata.setVariable("installerMode", "CLI");
        TestUtils.createMockInstallDir();
    }

    @After
    public void end() throws Exception {
        idata.getVariables().clear();
        handler = null;
    }

    /**
     * All individual ProcessPanel jobs must be able to be instantiated by the ProcessPanelWorker IzPack class
     */
    @Test
    public abstract void testProcessPanelInstantiation();


    public class MockProcessPanelWorker {

        public MockProcessPanelWorker(){}

        public void loadClass(String classname, AbstractUIProcessHandler handler) throws IllegalAccessException, InstantiationException, NoSuchMethodException, ClassNotFoundException {
            ClassLoader load = this.getClass().getClassLoader();
            Class procClass = load.loadClass(classname);
            Object o = procClass.newInstance();
            Method m = procClass.getMethod("run", new Class[]{AbstractUIProcessHandler.class, String[].class});
        }
    }
}
