#!/bin/sh

#all we need to do is run the installer with the auto install xml

if [ -z "$1" ] && [ "x" = x"$1" ]
then 
    echo "Usage:"
    echo "      default:       Installs to HOME/eap-installer-test-RANDOM-RANDOM-auto-default. No extra options chosen."
    echo "      quickstarts:   Installs to HOME/eap-installer-test-RANDOM-RANDOM-auto-quickstarts. Installs quickstarts, but no maven repo."
    echo "      quickstartsMR: Installs to HOME/eap-installer-test-RANDOM-RANDOM-auto-quickstartsMR. Installs quickstarts and the maven repo."
    echo "                     Maven repo location is hardcoded in the quickstartsMR.xml, change there once we have a real location"
    exit
fi

case $1 in
    default)
        cat default.xml | sed s.REPLACEHOME."$HOME".g | sed s.RANDOMDIR1."$RANDOM".g | sed s.RANDOMDIR2."$RANDOM".g > testscript
        ;;
    quickstarts)
        cat quickstarts.xml | sed s.REPLACEHOME."$HOME".g | sed s.RANDOMDIR1."$RANDOM".g | sed s.RANDOMDIR2."$RANDOM".g > testscript
        ;;
    quickstartsNoMR)
        cat quickstartsMR.xml | sed s.REPLACEHOME."$HOME".g | sed s.RANDOMDIR1."$RANDOM".g | sed s.RANDOMDIR2."$RANDOM".g | sed s.MAVENREPOLOC./"$HOME"/jboss-eap-6.0.0.DR13-maven-repository/.g > testscript
        ;;
esac

java -jar ../../target/jboss-eap-6.0.0.ER3-installer.jar testscript

rm testscript
