/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia.borders;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sourceforge.mlf.metouia.borders.MetouiaButtonBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaTextFieldBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaToggleButtonBorder;

public class MetouiaBorderUtilities {
    private static Border buttonBorder;
    private static Border textBorder;
    private static Border textFieldBorder;
    private static Border toggleButtonBorder;

    static void drawSimple3DBorder(Graphics g, Rectangle r) {
        MetouiaBorderUtilities.drawSimple3DBorder(g, r.x, r.y, r.width, r.height);
    }

    static void drawSimple3DBorder(Graphics g, int x, int y, int w, int h) {
        MetouiaBorderUtilities.drawSimple3DBorder(g, x, y, w, h, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow());
    }

    static void drawPressed3DBorder(Graphics g, Rectangle r) {
        MetouiaBorderUtilities.drawPressed3DBorder(g, r.x, r.y, r.width, r.height);
    }

    public static void drawDisabledBorder(Graphics g, int x, int y, int w, int h) {
        MetouiaBorderUtilities.drawSimple3DBorder(g, x, y, w, h, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlShadow());
    }

    static void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        MetouiaBorderUtilities.drawSimple3DBorder(g, x, y, w, h, MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControlHighlight());
    }

    public static final void drawSimple3DBorder(Graphics g, int x, int y, int w, int h, Color highlight, Color shadow) {
        g.translate(x, y);
        g.setColor(highlight);
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 1, 0, h - 1);
        g.setColor(shadow);
        g.drawLine(w - 1, 0, w - 1, h - 2);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.translate(-x, -y);
    }

    public static final void drawBevel3DBorder(Graphics g, int x, int y, int w, int h, Color highlight, Color shadow, Color innerHighlight, Color innerShadow) {
        g.translate(x, y);
        g.setColor(highlight);
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 1, 0, h - 1);
        g.setColor(shadow);
        g.drawLine(w - 1, 0, w - 1, h - 2);
        g.drawLine(1, h - 1, w - 1, h - 1);
        ++x;
        ++y;
        g.setColor(innerHighlight);
        g.drawLine(0, 0, --w - 2, 0);
        g.drawLine(0, 1, 0, --h - 1);
        g.setColor(innerShadow);
        g.drawLine(w - 1, 0, w - 1, h - 2);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.translate(-x, -y);
    }

    static void drawPressed3DFieldBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlHighlight());
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawRect(0, 0, w - 2, h - 2);
        g.translate(-x, -y);
    }

    static void drawDefaultButtonBorder(Graphics g, int x, int y, int w, int h) {
        MetouiaBorderUtilities.drawSimple3DBorder(g, x + 1, y + 1, w - 2, h - 2, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlShadow());
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawRect(x, y, w - 1, h - 1);
    }

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new MetouiaButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    public static Border getTextBorder() {
        if (textBorder == null) {
            textBorder = new BorderUIResource.CompoundBorderUIResource(new MetouiaTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new MetouiaTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new MetouiaToggleButtonBorder(), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    public static Border getDesktopIconBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new LineBorder(MetalLookAndFeel.getControlDarkShadow(), 1), new MatteBorder(2, 2, 1, 2, MetalLookAndFeel.getControl()));
    }
}

