package com.redhat.installer.password.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;

/**
 * Created by thauser on 2/10/15.
 */
public class SetMasterPassword {

    private static final String MASTER_VARS = "master.password.vars";
    private static final String MASTER_PASSWORD = "master.password.var";

    private static AutomatedInstallData idata;

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        idata = AutomatedInstallData.getInstance();
        setAllPasswordsToMasterPassword();
    }

    private static String[] getPasswordVariables(){
        String passwordVariables = idata.getVariable(MASTER_VARS);
        String[] split;
        if (passwordVariables != null){
            split = passwordVariables.split(",");
        } else {
            return null;
        }
        return split;
    }

    private static void setAllPasswordsToMasterPassword() {
        String[] passwords = getPasswordVariables();
        String masterPasswordVariable = idata.getVariable(MASTER_PASSWORD);
        String masterPassword = idata.getVariable(masterPasswordVariable);
        for (String password : passwords) {
            String existingPassword = idata.getVariable(password);
            if (existingPassword == null || existingPassword.isEmpty() && masterPassword != null)
                idata.setVariable(password, masterPassword);

        }
    }
}
