/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class EnumConverter
implements Converter,
PartialStateHolder {
    public static final String CONVERTER_ID = "javax.faces.Enum";
    public static final String ENUM_ID = "javax.faces.converter.EnumConverter.ENUM";
    public static final String ENUM_NO_CLASS_ID = "javax.faces.converter.EnumConverter.ENUM_NO_CLASS";
    private Class<? extends Enum> targetClass;
    private boolean isTransient = false;
    private boolean initialState;

    public EnumConverter() {
    }

    public EnumConverter(Class targetClass) {
        this.targetClass = targetClass;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (this.targetClass == null) {
            throw new ConverterException(MessageFactory.getMessage((FacesContext)context, (String)ENUM_NO_CLASS_ID, (Object[])new Object[]{value, MessageFactory.getLabel((FacesContext)context, (UIComponent)component)}));
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        try {
            return Enum.valueOf(this.targetClass, value);
        }
        catch (IllegalArgumentException iae) {
            throw new ConverterException(MessageFactory.getMessage((FacesContext)context, (String)ENUM_ID, (Object[])new Object[]{value, value, MessageFactory.getLabel((FacesContext)context, (UIComponent)component)}), (Throwable)iae);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (this.targetClass == null) {
            throw new ConverterException(MessageFactory.getMessage((FacesContext)context, (String)ENUM_NO_CLASS_ID, (Object[])new Object[]{value, MessageFactory.getLabel((FacesContext)context, (UIComponent)component)}));
        }
        if (value == null) {
            return "";
        }
        if (this.targetClass.isInstance(value)) {
            return ((Enum)value).name();
        }
        throw new ConverterException(MessageFactory.getMessage((FacesContext)context, (String)ENUM_ID, (Object[])new Object[]{value, value, MessageFactory.getLabel((FacesContext)context, (UIComponent)component)}));
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            this.targetClass = (Class)object;
        }
    }

    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            return this.targetClass;
        }
        return null;
    }

    public void setTransient(boolean b) {
        this.isTransient = b;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void markInitialState() {
        this.initialState = true;
    }

    public boolean initialStateMarked() {
        return this.initialState;
    }

    public void clearInitialState() {
        this.initialState = false;
    }
}

