package com.redhat.installer.dynamic.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ParameteredDataValidator;
import com.izforge.izpack.panels.UserInputPanel;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by aabulawi on 06/05/15.
 */
public class NoDuplicatesValidator extends ParameteredDataValidator {

    public static final String VAR_START = "variable_start";
    public static final String VAR_END = "variable_end";
    public static final String ERROR = "error";
    String errorMessage;

    @Override
    public Status validateData(AutomatedInstallData adata) {
        Map<String, String> params = getParameters();

        String componentVariable = adata.getVariable(params.get(VAR_START) + UserInputPanel.DYNAMIC_FIELD_COMPONENT_NUM_ENDING);
        String isEnabled = adata.getVariable(params.get(VAR_START));
        Boolean skip = isEnabled == null ? false : isEnabled.equals("No");

        if(componentVariable == null || skip) {
            return Status.SKIP;
        }
        int numberComponents = Integer.parseInt(componentVariable);
        Set<String> entries = new HashSet<String>();

        String errorKey = params.get(ERROR);
        errorMessage = adata.langpack.getString(errorKey);

        for (int i=1; i <= numberComponents; i++){
            entries.add(adata.getVariable(String.format("%s-%d-%s", params.get(VAR_START), i, params.get(VAR_END))));
        }
        if (entries.size() != numberComponents)
            return Status.ERROR;
        return Status.OK;

    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return errorMessage;
    }
}
