package com.izforge.izpack.gui;

import com.izforge.izpack.gui.patternfly.PatternflyComboBoxUI;

import javax.swing.*;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import java.awt.event.*;
import java.util.Vector;

/**
 * Created by thauser on 5/7/15.
 */
public class ComboBoxFactory {
    public static JComboBox createComboBox(){
       return setPatternFlyUI(new JComboBox());
    }

    public static JComboBox createComboBox(ComboBoxModel theModel){
        return setPatternFlyUI(new JComboBox(theModel));
    }


    public static JComboBox createComboBox(Vector items){
        return setPatternFlyUI(new JComboBox(items));
    }

    public static JComboBox createComboBox(Object[]objects){
        return setPatternFlyUI(new JComboBox(objects));
    }

    private static JComboBox setPatternFlyUI(final JComboBox comboBox){
        comboBox.addFocusListener(new FocusListener() {
            @Override
            public void focusGained(FocusEvent focusEvent) {
                comboBox.showPopup();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        return comboBox;
    }
}
