package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import org.jboss.dmr.ModelNode;

import java.util.List;

/**
 * Deploys an artifact onto the currently running server
 * Created by thauser on 7/8/15.
 */
public class DeployArtifact extends PostInstallation {
    private static final String ARTIFACT_PATH = "path";

    @Override
    protected Class getClassName() {
        return DeployArtifact.class;
    }

    @Override
    protected boolean performOperation() {
        return deployArtifact();
    }

    private static boolean deployArtifact() {
        return serverCommands.deployArtifact(parser.getStringProperty(ARTIFACT_PATH));
    }
}
