/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.client.widgets.views.session;

import javax.enterprise.context.Dependent;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;

@Dependent
public class NoCanvasView implements IsWidget {

    private final FlowPanel mainPanel = new FlowPanel();

    public void show() {
        mainPanel.add(new Heading(HeadingSize.H6,
                                  "No diagram in use"));
    }

    public void clear() {
        mainPanel.clear();
    }

    @Override
    public Widget asWidget() {
        return mainPanel;
    }
}
