// $Id: Group.java 5698 2008-01-15 09:45:17 -0500 (Tue, 15 Jan 2008) dgeraskov $
package mapping.exception;

import java.util.Set;

/**
 * Implementation of Group.
 *
 * @author Steve Ebersole
 */
public class Group {
	private Long id;
	private String name;
	private Set members;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Set getMembers() {
		return members;
	}

	public void setMembers(Set members) {
		this.members = members;
	}

	public void addMember(User member) {
		if (member == null) {
			throw new IllegalArgumentException("Member to add cannot be null");
		}

		this.members.add(member);
		member.getMemberships().add(this);
	}
}
