package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.Subject;

public class SubjectDomAdapter extends JpdlElementDomAdapter {
	
	protected void initialize() {
		super.initialize();
		Subject subject = (Subject)getJpdlElement();
		if (subject != null) {
			setTextContent(subject.getSubject());
		}
	}

	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		Subject subject = (Subject)jpdlElement;
		subject.setSubject(getTextContent());
		subject.addPropertyChangeListener(this);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("subject".equals(evt.getPropertyName())) {
			setTextContent((String)evt.getNewValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		Subject subject = (Subject)getJpdlElement();
		if ("#text".equals(name)) {
			subject.setSubject(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		// a subject cannot have any child nodes
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		// a subject cannot have any child nodes
	}
	
}
