package org.jbpm.gd.jpdl.ui.actions;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.ui.editor.JpdlEditor;
import org.jbpm.gd.jpdl.ui.outline.JpdlEditorOutlinePage;

public abstract class JpdlObjectActionDelegate implements IObjectActionDelegate {

	private IWorkbenchPart targetPart;
	private EditPart selectedPart;

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.targetPart = targetPart;
	}
	
	private CommandStack getCommandStack() {
		if (targetPart instanceof ContentOutline) {
			return ((JpdlEditorOutlinePage)((ContentOutline)targetPart).getCurrentPage()).getCommandStack();
		} else if (targetPart instanceof JpdlEditor) {
			return ((JpdlEditor)targetPart).getCommandStack();
		} else {
			return null;
		}
	}
	
	protected AbstractJpdlElement getJpdlElement() {
		Object model = selectedPart.getModel();
		if (model instanceof AbstractNotationElement) {
			model = ((AbstractNotationElement)model).getSemanticElement();
		}
		return (AbstractJpdlElement)model;
	}
	
	protected abstract Command getCommand(IAction action); 
	
	public void run(IAction action) {
		CommandStack commandStack = getCommandStack();
		if (commandStack != null) {
			commandStack.execute(getCommand(action));
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		if (selection == null) return;
		if (!(selection instanceof StructuredSelection)) return;
		Object object = ((StructuredSelection)selection).getFirstElement();
		if (object instanceof EditPart) {
			selectedPart = (EditPart)object;
		}
	}
	
}
