/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.gd.jpdl.ui.command;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.model.StartState;

public class NodeCreateCommand extends Command {
	
	private Node node;
	private Point location;
	protected AbstractNotationElement parent;
	
	public void execute() {
		setConstraint();
		setName();
		node.register();
		addAbstractNode(getNodeElementContainer(), getAbstractNode());
	}
	
	private void addAbstractNode(NodeElementContainer nodeElementContainer, AbstractNode abstractNode) {
		if (abstractNode instanceof StartState && nodeElementContainer instanceof ProcessDefinition) {
			((ProcessDefinition)nodeElementContainer).addStartState((StartState)abstractNode);
		} else {
			nodeElementContainer.addNodeElement(abstractNode);
		}
	}
	
	private void removeAbstractNode(NodeElementContainer nodeElementContainer, AbstractNode abstractNode) {
		if (abstractNode instanceof StartState && nodeElementContainer instanceof ProcessDefinition) {
			((ProcessDefinition)nodeElementContainer).removeStartState((StartState)abstractNode);
		} else {
			nodeElementContainer.removeNodeElement(abstractNode);
		}
	}
	
	private NodeElementContainer getNodeElementContainer() {
		return (NodeElementContainer)parent.getSemanticElement();
	}
	
	private AbstractNode getAbstractNode() {
		return (AbstractNode)node.getSemanticElement();
	}
	
	public boolean canExecute() {
		return getNodeElementContainer().canAdd(getAbstractNode());
	}
	
	private void setName() {
		if (getAbstractNode().getName() == null) {
			getAbstractNode().initializeName(getNodeElementContainer());
		}
	}
	
	private void setConstraint() {
		if (location != null) {
			Dimension dimension = new Dimension (-1, -1);
			Rectangle rectangle = node.getConstraint();
			if (rectangle != null && rectangle.getSize() != null) {
				dimension = rectangle.getSize();
			}
			node.setConstraint(new Rectangle(location, dimension));
		}		
	}
	
	public void undo() {
		removeAbstractNode(getNodeElementContainer(), getAbstractNode());
	}
	
	public void setNode(Node node) {
		this.node = node;
	}
	
	public void setLocation(Point location) {
		this.location = location;
	}
	
	public void setParent(AbstractNotationElement parent) {
		this.parent = parent;
	}
	

}
