package org.jbpm.gd.jpdl.ui.editor;

import org.eclipse.gef.requests.CreationFactory;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.notation.NotationElementFactory;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.ui.notation.JpdlNotationMapping;

public class JpdlCreationFactory implements CreationFactory {	
	
	String elementId;
	
	public JpdlCreationFactory(String elementId) {
		this.elementId = elementId;
	}

	public Object getNewObject() {
		AbstractNotationElement notationElement = NotationElementFactory.INSTANCE.create(JpdlNotationMapping.getNotationElementId(elementId));
		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createById(elementId);
		notationElement.setSemanticElement(jpdlElement);
		return notationElement;
	}

	public Object getObjectType() {
		return elementId;
	}

}
