package org.jbpm.gd.jpdl.ui.graph.part;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Label;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.common.notation.RootContainer;

public class NotationElementGraphicalEditPartFactory implements EditPartFactory {

	public EditPart createEditPart(EditPart context, Object model) {
		if (model == null) return null;
		if (model instanceof RootContainer) {
			return new RootContainerGraphicalEditPart((RootContainer)model);
		} else if (model instanceof NodeContainer) {
			return new NodeContainerGraphicalEditPart((NodeContainer)model);
		} else if (model instanceof Node){
			return new NodeGraphicalEditPart((Node)model);
		} else if (model instanceof Edge) {
			return new EdgeGraphicalEditPart((Edge)model);
		} else if (model instanceof Label) {
			return new LabelGraphicalEditPart((Label)model);
		}
		return null;
	}

}
