package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Delegation;

public class DelegationConfigurationText implements SelectionListener, FocusListener {
	
	public static final Policy CONSTRUCTOR_POLICY = new ConstructorPolicy();
	public static final Policy COMPATIBILITY_POLICY = new CompatibilityPolicy();

	private TabbedPropertySheetWidgetFactory widgetFactory;
	private DelegationConfigurationComposite delegationConfigurationComposite;	
	private Policy policy;	
	
	private Text text;

	public static DelegationConfigurationText create(
			TabbedPropertySheetWidgetFactory widgetFactory, DelegationConfigurationComposite delegationConfigurationComposite, Policy policy) {
		DelegationConfigurationText result = new DelegationConfigurationText();
		result.widgetFactory = widgetFactory;
		result.delegationConfigurationComposite = delegationConfigurationComposite;
		result.policy = policy;
		result.create();
		return result;
	}

	private void create() {
		text = widgetFactory.createText(delegationConfigurationComposite.getParent(), "", SWT.V_SCROLL | SWT.H_SCROLL);
		hookListeners();
	}
	
	public void setLayoutData(Object layoutData) {
		text.setLayoutData(layoutData);
	}
	
	public void setVisible(boolean visible) {		
		if (visible) {
			delegationConfigurationComposite.getConfigInfoLabel().setVisible(true);
			delegationConfigurationComposite.getMessageLabel().setVisible(false);
			Delegation delegation = delegationConfigurationComposite.getDelegation();
			if (delegation != null) {
				delegation.setConfigInfoString(text.getText());
			}
		}
		text.setVisible(visible);
	}
	
	public void setText(String str) {
		text.setText(str);
	}
	
	public void refreshDelegationInfo() {
		unhookListeners();
		Delegation delegation = delegationConfigurationComposite.getDelegation();
		if (delegation != null && policy.getType().equals(delegation.getConfigType())) {
			String info = delegation.getConfigInfoString();
			setText(info == null ? "" : info);
		} else {
			setText("");
		}
		setVisible(delegation != null && policy.getType().equals(delegation.getConfigType()));
		hookListeners();
	}
	
	private void hookListeners() {
		text.addFocusListener(this);
		text.addSelectionListener(this);
	}
	
	private void unhookListeners() {
		text.removeFocusListener(this);
		text.removeSelectionListener(this);
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		updateConfigInfoString();
	}

	public void widgetSelected(SelectionEvent e) {
	}

	public void focusGained(FocusEvent e) {
	}

	public void focusLost(FocusEvent e) {
		updateConfigInfoString();
	}
	
	private void updateConfigInfoString() {
		Delegation delegation = delegationConfigurationComposite.getDelegation();
		if (delegation == null) return;
		if ("configuration-property".equals(delegation.getConfigType()) ||
				"constructor".equals(delegation.getConfigType())) {
			delegation.setConfigInfoString(text.getText());
		}		
	}
	
	private static abstract class Policy {
		protected abstract String getType();
	}
	
	private static class ConstructorPolicy extends Policy {		
		protected String getType() {
			return "constructor";
		}
	}
	
	private static class CompatibilityPolicy extends Policy {
		protected String getType() {
			return "configuration-property";
		}
	}

}
