/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.UITree;
import org.richfaces.component.UITreeNode;
import org.richfaces.component.nsutils.NSUtils;
import org.richfaces.component.state.TreeState;
import org.richfaces.component.state.TreeStateAdvisor;
import org.richfaces.model.LastElementAware;
import org.richfaces.model.TreeRange;
import org.richfaces.model.TreeRowKey;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.Context;
import org.richfaces.renderkit.DnDParametersEncoder;
import org.richfaces.renderkit.DraggableRendererContributor;
import org.richfaces.renderkit.DropzoneRendererContributor;
import org.richfaces.renderkit.Flag;
import org.richfaces.renderkit.TreeDataModelEventNavigator;

public abstract class TreeRendererBase
extends CompositeRenderer {
    protected static final Comparator treeRowKeyComparator = new Comparator(){

        public int compare(Object key1, Object key2) {
            TreeRowKey treeRowKey1 = (TreeRowKey)key1;
            TreeRowKey treeRowKey2 = (TreeRowKey)key2;
            if (treeRowKey1 == null) {
                if (treeRowKey2 == null) {
                    return 0;
                }
                return -1;
            }
            if (treeRowKey2 == null) {
                return 1;
            }
            Iterator iterator1 = treeRowKey1.iterator();
            Iterator iterator2 = treeRowKey2.iterator();
            while (iterator1.hasNext() && iterator2.hasNext()) {
                String id2;
                String id1 = iterator1.next().toString();
                int cr = id1.compareTo(id2 = iterator2.next().toString());
                if (cr == 0) continue;
                return cr;
            }
            if (iterator1.hasNext()) {
                return 1;
            }
            if (iterator2.hasNext()) {
                return -1;
            }
            return 0;
        }
    };

    public TreeRendererBase() {
        this.addContributor(DraggableRendererContributor.getInstance());
        this.addContributor(DropzoneRendererContributor.getInstance());
        this.addParameterEncoder(DnDParametersEncoder.getInstance());
    }

    public void writeNamespace(FacesContext context, UIComponent component) throws IOException {
        NSUtils.writeNameSpace((FacesContext)context, (UIComponent)component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeAjaxChildren(FacesContext context, UIComponent component, String path, Set ids, Set renderedAreas) throws IOException {
        block24: {
            super.encodeAjaxChildren(context, component, path, ids, renderedAreas);
            try {
                if (!(component instanceof UITree)) break block24;
                UITree tree = (UITree)component;
                String id = path + tree.getId();
                tree.captureOrigValue();
                boolean encodeScripts = false;
                tree.setRowKey(context, null);
                ResponseWriter responseWriter = context.getResponseWriter();
                responseWriter.startElement("div", (UIComponent)tree);
                this.writeNamespace(context, component);
                ArrayList<String> encodedAreaIds = new ArrayList<String>();
                try {
                    Set ajaxKeys = tree.getAllAjaxKeys();
                    if (ajaxKeys != null) {
                        ArrayList sortedKeys = new ArrayList(ajaxKeys.size());
                        sortedKeys.addAll(ajaxKeys);
                        Collections.sort(sortedKeys, treeRowKeyComparator);
                        Iterator ajaxKeysItr = sortedKeys.iterator();
                        TreeRowKey lastKey = null;
                        boolean nullRoot = false;
                        while (!nullRoot && ajaxKeysItr.hasNext()) {
                            TreeRowKey key = (TreeRowKey)ajaxKeysItr.next();
                            if (lastKey == null) {
                                lastKey = key;
                            } else {
                                if (lastKey.isSubKey(key)) continue;
                                lastKey = key;
                            }
                            if (key == null || key.depth() == 0) {
                                nullRoot = true;
                                key = null;
                            }
                            tree.setRowKey(context, key);
                            if (tree.isRowAvailable()) {
                                String treeClientId = key == null ? tree.getClientId(context) : tree.getNodeFacet().getClientId(context);
                                String treeChildrenId = treeClientId + ':' + "childs";
                                this.writeContent(context, tree, key);
                                encodeScripts = true;
                                renderedAreas.add(treeClientId);
                                encodedAreaIds.add(treeClientId);
                                renderedAreas.add(treeChildrenId);
                                continue;
                            }
                            String cid = tree.getClientId(context);
                            String message = MessageFormat.format("Failed to re-render tree node: {0} due to model data unavailability! Maybe parent node should be re-rendered instead?", cid);
                            ExternalContext externalContext = context.getExternalContext();
                            externalContext.log(message);
                        }
                    }
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
                finally {
                    try {
                        tree.setRowKey(context, null);
                        tree.restoreOrigValue();
                    }
                    catch (Exception e) {
                        context.getExternalContext().log(e.getMessage(), (Throwable)e);
                    }
                }
                if (encodeScripts) {
                    this.writeScript(context, tree, encodedAreaIds, renderedAreas);
                    String inputId = this.encodeSelectionStateInput(context, tree);
                    if (inputId != null) {
                        renderedAreas.add(inputId);
                    }
                }
                responseWriter.endElement("div");
                tree.clearRequestKeysSet();
            }
            finally {
                try {
                    ComponentsVariableResolver.removeVariables((RendererBase)this, (UIComponent)component);
                }
                catch (Exception e) {
                    context.getExternalContext().log(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encodeSelectionStateInput(FacesContext context, UITree tree) throws IOException {
        String result = "";
        TreeState treeState = (TreeState)tree.getComponentState();
        TreeRowKey selectedNodeKey = treeState.getSelectedNode();
        if (selectedNodeKey != null) {
            Object rowKey = tree.getRowKey();
            try {
                tree.setRowKey(selectedNodeKey);
                if (tree.isRowAvailable()) {
                    result = tree.getNodeFacet().getClientId(context);
                }
            }
            finally {
                try {
                    tree.setRowKey(rowKey);
                }
                catch (Exception e) {
                    context.getExternalContext().log(e.getMessage(), (Throwable)e);
                }
            }
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)tree);
        writer.writeAttribute("type", (Object)"hidden", null);
        String selectionHolderInputId = tree.getSelectionStateInputName(context);
        writer.writeAttribute("id", (Object)selectionHolderInputId, null);
        writer.writeAttribute("name", (Object)selectionHolderInputId, null);
        writer.writeAttribute("value", (Object)result, null);
        writer.endElement("input");
        return selectionHolderInputId;
    }

    protected String getAjaxScript(FacesContext context, UITree tree) {
        String id = tree.getBaseClientId(context);
        JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)tree, (FacesContext)context);
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)tree);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.remove(id);
        parameters.put(id + ":selectedNode", new JSReference("event.selectedNode"));
        function.addParameter((Object)eventOptions);
        StringBuffer buffer = new StringBuffer();
        function.appendScript(buffer);
        buffer.append("; return false;");
        return buffer.toString();
    }

    protected String getScriptContributions(FacesContext context, UITree tree) {
        return super.getScriptContributions(this.getJavaScriptVarName(context, tree), context, (UIComponent)tree);
    }

    protected String getJavaScriptVarName(FacesContext context, UITree tree) {
        String id = tree.getBaseClientId(context);
        return "Richfaces_Tree_" + id.replaceAll("[^A-Za-z0-9_]", "_");
    }

    private void writeScript(FacesContext context, UITree tree, List encodedAreaIds, Set renderedAreas) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getBaseClientId(context);
        String scriptId = clientId + ':' + "script";
        writer.startElement("div", (UIComponent)tree);
        this.getUtils().writeAttribute(writer, "id", (Object)scriptId);
        writer.startElement("script", (UIComponent)tree);
        this.getUtils().writeAttribute(writer, "type", (Object)"text/javascript");
        String varName = this.getJavaScriptVarName(context, tree);
        writer.writeText((Object)(varName + ".getNodeElements(" + ScriptUtils.toScript((Object)encodedAreaIds) + ");"), null);
        writer.endElement("script");
        writer.endElement("div");
        renderedAreas.add(scriptId);
        renderedAreas.add(tree.getClientId(context) + ':' + "input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.writeContent(context, (UITree)component, null);
    }

    public void writeContent(FacesContext context, UITree input) throws IOException {
        this.writeContent(context, input, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(final FacesContext context, final UITree input, TreeRowKey key) throws IOException {
        Flag droppedDownToLevelFlag = new Flag();
        TreeRowKey rowKey = key;
        try {
            input.captureOrigValue();
            if (key != null) {
                droppedDownToLevelFlag.setContext(null);
                input.setRowKey(context, key);
            } else {
                input.setRowKey(context, null);
            }
            RendererDataModelEventNavigator levelNavigator = new RendererDataModelEventNavigator(input, rowKey, context, droppedDownToLevelFlag);
            final TreeRange stateRange = (TreeRange)input.getComponentState().getRange();
            TreeRange treeRange = new TreeRange(){

                public boolean processChildren(TreeRowKey rowKey) {
                    return stateRange.processChildren(rowKey);
                }

                public boolean processNode(TreeRowKey rowKey) {
                    UITreeNode nodeFacet;
                    Object currentKey = input.getRowKey();
                    if (currentKey == null ? rowKey != null : !currentKey.equals(rowKey)) {
                        input.setRowKey(context, rowKey);
                    }
                    if (!(nodeFacet = input.getNodeFacet()).isRendered()) {
                        return false;
                    }
                    return stateRange.processNode(rowKey);
                }
            };
            input.walk(context, new DataVisitorWithLastElement(droppedDownToLevelFlag, input, levelNavigator, key), (Range)treeRange, key, null);
            levelNavigator.followRowKey(context, null);
        }
        finally {
            input.setRowKey(context, null);
            input.restoreOrigValue();
        }
    }

    private class DataVisitorWithLastElement
    implements DataVisitor,
    LastElementAware {
        private boolean isLastElement = false;
        private final Flag flag;
        private final UITree tree;
        private final RendererDataModelEventNavigator navigator;
        private TreeStateAdvisor methodBindingAdvisor = null;
        private Object floatingKey;

        private DataVisitorWithLastElement(Flag flag, UITree tree, RendererDataModelEventNavigator navigator, Object rowKey) {
            this.flag = flag;
            this.tree = tree;
            this.navigator = navigator;
            this.floatingKey = rowKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            this.processAdvisors(context, (TreeRowKey)rowKey);
            this.navigator.followRowKey(context, (TreeRowKey)rowKey);
            Context c = this.flag.getContext();
            if (c != null) {
                c.setHasChildren(false);
                this.navigator.openDiv(c);
                this.navigator.closeDiv();
            }
            UITreeNode nodeFacet = this.tree.getNodeFacet();
            Object oldAttrValue = nodeFacet.getAttributes().get("isLastElement");
            Object oldAjaxRootAttrValue = nodeFacet.getAttributes().get("isAjaxUpdateRoot");
            try {
                nodeFacet.getAttributes().put("isLastElement", new Boolean(this.isLastElement));
                nodeFacet.getAttributes().put("isAjaxUpdateRoot", new Boolean(this.floatingKey != null && this.floatingKey.equals(rowKey)));
                ResponseWriter writer = context.getResponseWriter();
                if (this.isLastElement && this.navigator.showLines) {
                    writer.startElement("p", (UIComponent)this.tree);
                    writer.writeAttribute("class", (Object)"dr-tree-last-node-marker", null);
                    writer.endElement("p");
                }
                TreeRendererBase.this.renderChild(context, (UIComponent)nodeFacet);
                c = new Context();
                c.setClientId(nodeFacet.getClientId(context) + ':');
                c.setLast(this.isLastElement);
                c.setExpanded(this.tree.isExpanded());
                c.setRowKey(this.tree.getRowKey());
                this.flag.setContext(c);
            }
            finally {
                if (oldAttrValue != null) {
                    nodeFacet.getAttributes().put("isLastElement", oldAttrValue);
                } else {
                    nodeFacet.getAttributes().remove("isLastElement");
                }
                if (oldAjaxRootAttrValue != null) {
                    nodeFacet.getAttributes().put("isAjaxUpdateRoot", oldAjaxRootAttrValue);
                } else {
                    nodeFacet.getAttributes().remove("isAjaxUpdateRoot");
                }
            }
        }

        public void setLastElement() {
            this.isLastElement = true;
            this.navigator.setLastElement();
        }

        public void resetLastElement() {
            this.isLastElement = false;
            this.navigator.resetLastElement();
        }

        public void processAdvisors(FacesContext context, TreeRowKey rowKey) throws IOException {
            Boolean adviseSelected;
            Boolean adviseOpened;
            TreeState componentState = (TreeState)this.tree.getComponentState();
            TreeStateAdvisor stateAdvisor = (TreeStateAdvisor)this.tree.getStateAdvisor();
            if (null == stateAdvisor) {
                if (null == this.methodBindingAdvisor) {
                    this.methodBindingAdvisor = new TreeStateAdvisor(){

                        public Boolean adviseNodeOpened(UITree tree) {
                            MethodBinding adviseNodeOpened = tree.getAdviseNodeOpened();
                            if (null != adviseNodeOpened) {
                                return (Boolean)adviseNodeOpened.invoke(FacesContext.getCurrentInstance(), new Object[]{tree});
                            }
                            return null;
                        }

                        public Boolean adviseNodeSelected(UITree tree) {
                            MethodBinding adviseNodeSelected = tree.getAdviseNodeSelected();
                            if (null != adviseNodeSelected) {
                                return (Boolean)adviseNodeSelected.invoke(FacesContext.getCurrentInstance(), new Object[]{tree});
                            }
                            return null;
                        }
                    };
                }
                stateAdvisor = this.methodBindingAdvisor;
            }
            if (null != (adviseOpened = stateAdvisor.adviseNodeOpened(this.tree))) {
                if (adviseOpened.booleanValue()) {
                    if (!componentState.isExpanded(rowKey)) {
                        componentState.expandNode(this.tree, rowKey);
                    }
                } else if (componentState.isExpanded(rowKey)) {
                    componentState.collapseNode(this.tree, rowKey);
                }
            }
            if (null != (adviseSelected = stateAdvisor.adviseNodeSelected(this.tree))) {
                if (adviseSelected.booleanValue()) {
                    if (!componentState.isSelected(rowKey)) {
                        componentState.setSelected(rowKey);
                    }
                } else if (componentState.isSelected(rowKey)) {
                    componentState.setSelected(null);
                }
            }
        }
    }

    private final class RendererDataModelEventNavigator
    extends TreeDataModelEventNavigator {
        private final FacesContext context;
        private final UITree tree;
        private final Flag droppedDownToLevelFlag;
        private final ResponseWriter writer;
        private String clientId;
        private boolean expanded;
        private boolean showLines;

        private RendererDataModelEventNavigator(UITree tree, TreeRowKey floatingKey, FacesContext context, Flag droppedDownToLevelFlag) {
            super(tree, floatingKey);
            this.context = context;
            this.tree = tree;
            this.droppedDownToLevelFlag = droppedDownToLevelFlag;
            this.writer = context.getResponseWriter();
            this.expanded = this.tree.isExpanded();
            this.showLines = this.tree.isShowConnectingLines();
            this.clientId = this.getClientId();
        }

        public void followRowKey(FacesContext context, TreeRowKey newRowKey) throws IOException {
            super.followRowKey(context, newRowKey);
            this.expanded = this.tree.isExpanded();
            this.clientId = this.getClientId();
        }

        private String getClientId() {
            Object rowKey = this.tree.getRowKey();
            String id = rowKey == null ? this.tree.getClientId(this.context) + ':' : this.tree.getNodeFacet().getClientId(this.context) + ':';
            return id;
        }

        public void afterUp(int levels) throws IOException {
            Context c = this.droppedDownToLevelFlag.getContext();
            if (c != null) {
                c.setHasChildren(false);
                this.openDiv(c);
                this.closeDiv();
                this.droppedDownToLevelFlag.setContext(null);
            }
            for (int i = 0; i < levels; ++i) {
                this.closeDiv();
            }
        }

        public void afterDown() throws IOException {
        }

        public void beforeDown() throws IOException {
            Context c = this.droppedDownToLevelFlag.getContext();
            this.droppedDownToLevelFlag.setContext(null);
            this.openDiv(c);
        }

        public void beforeUp(int levels) throws IOException {
        }

        public void openDiv(Context context) throws IOException {
            TreeRowKey floatingKey;
            this.writer.startElement("div", (UIComponent)this.tree);
            if (context == null) {
                context = new Context();
                context.setLast(this.actualLast);
                context.setClientId(this.clientId);
                context.setExpanded(this.expanded);
                context.setRowKey(this.getRowKey());
            }
            TreeRendererBase.this.getUtils().writeAttribute(this.writer, "id", (Object)(context.getClientId() + "childs"));
            if (!context.isExpanded() || !context.isHasChildren()) {
                TreeRendererBase.this.getUtils().writeAttribute(this.writer, "style", (Object)"display: none;");
            } else if (this.tree.isShowConnectingLines() && (floatingKey = this.getFloatingKey()) != null && floatingKey.equals(context.getRowKey())) {
                String expression = "background-image:expression(this.nextSibling ? '' : 'none')";
                TreeRendererBase.this.getUtils().writeAttribute(this.writer, "style", (Object)expression);
            }
            String styleClasses = "";
            if (context.getRowKey() != null) {
                styleClasses = "dr-tree-layout-on dr-tree-h-ic-div rich-tree-node-children rich-tree-node-cildren";
                if (!context.isLast() && this.showLines) {
                    styleClasses = styleClasses + " dr-tree-h-ic-line";
                }
            }
            if (styleClasses != "") {
                TreeRendererBase.this.getUtils().writeAttribute(this.writer, "class", (Object)styleClasses);
            }
        }

        public void closeDiv() throws IOException {
            this.writer.endElement("div");
        }
    }
}

