/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import org.ajax4jsf.el.ELContextWrapper;
import org.ajax4jsf.util.CapturingELResolver;
import org.richfaces.validator.FacesBeanValidator;
import org.richfaces.validator.GraphValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIGraphValidator
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.richfaces.GraphValidator";
    public static final String COMPONENT_FAMILY = "org.richfaces.GraphValidator";
    public static final String STATE_ATTRIBUTE_PREFIX = "org.richfaces.GraphValidator:";

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract String getSummary();

    public abstract void setSummary(String var1);

    public abstract Object getProfiles();

    public abstract void setProfiles(Object var1);

    public abstract String getType();

    public abstract void setType(String var1);

    public void processDecodes(FacesContext context) {
        Object value;
        GraphValidatorState validatorState = null;
        ValueExpression valueExpression = this.getValueExpression("value");
        if (null != valueExpression && null != (value = this.getValue()) && value instanceof Cloneable) {
            try {
                ELContext initialELContext = context.getELContext();
                CapturingELResolver capturingELResolver = new CapturingELResolver(initialELContext.getELResolver());
                Class type = valueExpression.getType((ELContext)new ELContextWrapper(initialELContext, (ELResolver)capturingELResolver));
                if (null != type) {
                    validatorState = new GraphValidatorState();
                    Method method = this.getCloneMethod(value.getClass());
                    if (!Modifier.isPublic(method.getModifiers())) {
                        method.setAccessible(true);
                    }
                    validatorState.cloned = method.invoke(value, new Object[0]);
                    validatorState.base = capturingELResolver.getBase();
                    validatorState.property = capturingELResolver.getProperty();
                    validatorState.active = true;
                    context.getExternalContext().getRequestMap().put(this.getStateId(context), validatorState);
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
                throw new FacesException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                throw new FacesException((Throwable)e);
            }
        }
        super.processDecodes(context);
        if (null != validatorState) {
            validatorState.active = false;
        }
    }

    private Method getCloneMethod(Class<?> clazz) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (null != clazz.getSuperclass()) {
                return this.getCloneMethod(clazz.getSuperclass());
            }
            throw e;
        }
    }

    protected String getStateId(FacesContext context) {
        String stateId = STATE_ATTRIBUTE_PREFIX + this.getClientId(context);
        return stateId;
    }

    protected GraphValidatorState getValidatorState(FacesContext context) {
        return (GraphValidatorState)context.getExternalContext().getRequestMap().get(this.getStateId(context));
    }

    public void processValidators(FacesContext context) {
        GraphValidatorState validatorState = this.getValidatorState(context);
        if (null != validatorState) {
            validatorState.active = true;
        }
        super.processValidators(context);
        if (null != validatorState) {
            validatorState.active = false;
            this.validateObject(context, validatorState.cloned);
            context.getExternalContext().getRequestMap().remove(this.getStateId(context));
        }
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        Object value = this.getValue();
        this.validateObject(context, value);
    }

    private void validateObject(FacesContext context, Object value) {
        if (null != value) {
            Validator validator = context.getApplication().createValidator(this.getType());
            if (validator instanceof GraphValidator) {
                GraphValidator graphValidator = (GraphValidator)validator;
                Collection messages = graphValidator.validateGraph(context, (UIComponent)this, value, this.getProfiles());
                if (null != messages) {
                    context.renderResponse();
                    String clientId = this.getClientId(context);
                    for (String msg : messages) {
                        String summary = null != this.getSummary() ? this.getSummary() + msg : msg;
                        context.addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, msg));
                    }
                }
            } else {
                throw new FacesException("Validator org.richfaces.BeanValidator does not implement GraphValidator");
            }
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        FacesBeanValidator validator = (FacesBeanValidator)context.getApplication().createValidator(this.getType());
        validator.setSummary(this.getSummary());
        ValueExpression expression = this.getValueExpression("profiles");
        if (null != expression) {
            validator.setProfiles(expression);
        } else {
            validator.setProfiles(this.getProfiles());
        }
        this.setupValidators((UIComponent)this, (Validator)validator);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (this.isRendered()) {
            for (UIComponent child : this.getChildren()) {
                if (!child.isRendered()) continue;
                child.encodeAll(context);
            }
        }
    }

    private void setupValidators(UIComponent component, Validator validator) {
        Iterator facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent child = (UIComponent)facetsAndChildren.next();
            if (child instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)child;
                this.setupValidator(input, validator);
            }
            this.setupValidators(child, validator);
        }
    }

    private void setupValidator(EditableValueHolder input, Validator validator) {
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            if (!(validators[i] instanceof FacesBeanValidator)) continue;
            return;
        }
        input.addValidator(validator);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public static final class GraphValidatorState {
        private boolean active = false;
        private Object cloned;
        private Object base;
        private Object property;

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Object getCloned() {
            return this.cloned;
        }

        public void setCloned(Object cloned) {
            this.cloned = cloned;
        }

        public Object getBase() {
            return this.base;
        }

        public void setBase(Object base) {
            this.base = base;
        }

        public Object getProperty() {
            return this.property;
        }

        public void setProperty(Object property) {
            this.property = property;
        }

        public boolean isSameBase(Object base) {
            return null == base && null == this.base || base == this.base;
        }

        public boolean isSameProperty(Object property) {
            if (null == this.property) {
                return null == property;
            }
            return this.property.equals(property);
        }

        public boolean isSame(Object base, Object property) {
            return this.isSameBase(base) && this.isSameProperty(property) && this.active;
        }
    }
}

