/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class Classpath {
    public static URL[] search(String prefix, String suffix) throws IOException {
        return Classpath.search(Thread.currentThread().getContextClassLoader(), prefix, suffix);
    }

    public static URL[] search(ClassLoader cl, String prefix, String suffix) throws IOException {
        Enumeration<URL> e = cl.getResources(prefix);
        HashSet all = new HashSet();
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            conn.setDefaultUseCaches(false);
            JarFile jarFile = conn instanceof JarURLConnection ? ((JarURLConnection)conn).getJarFile() : Classpath.getAlternativeJarFile(url);
            if (jarFile != null) {
                Classpath.searchJar(cl, all, jarFile, prefix, suffix);
                continue;
            }
            Classpath.searchDir(all, new File(url.getFile()), suffix);
        }
        URL[] urlArray = all.toArray(new URL[all.size()]);
        return urlArray;
    }

    private static void searchDir(Set result, File file, String suffix) throws IOException {
        if (file.exists() && file.isDirectory()) {
            File[] fc = file.listFiles();
            for (int i = 0; i < fc.length; ++i) {
                String path = fc[i].getAbsolutePath();
                if (fc[i].isDirectory()) {
                    Classpath.searchDir(result, fc[i], suffix);
                    continue;
                }
                if (!path.endsWith(suffix)) continue;
                result.add(fc[i].toURL());
            }
        }
    }

    private static JarFile getAlternativeJarFile(URL url) throws IOException {
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex == -1) {
            separatorIndex = urlFile.indexOf(33);
        }
        if (separatorIndex != -1) {
            String jarFileUrl = urlFile.substring(0, separatorIndex);
            if (jarFileUrl.startsWith("file:")) {
                jarFileUrl = jarFileUrl.substring("file:".length());
            }
            return new JarFile(jarFileUrl);
        }
        return null;
    }

    private static void searchJar(ClassLoader cl, Set result, JarFile file, String prefix, String suffix) throws IOException {
        Enumeration<JarEntry> e = file.entries();
        while (e.hasMoreElements()) {
            JarEntry entry;
            try {
                entry = e.nextElement();
            }
            catch (Throwable t) {
                continue;
            }
            String name = entry.getName();
            if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
            Enumeration<URL> e2 = cl.getResources(name);
            while (e2.hasMoreElements()) {
                result.add(e2.nextElement());
            }
        }
    }
}

