/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reflection.java;

import java.lang.reflect.Type;
import java.util.Collection;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.java.JavaXFactory;
import org.hibernate.reflection.java.generics.TypeEnvironment;
import org.hibernate.reflection.java.generics.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JavaXType {
    private final TypeEnvironment context;
    private final JavaXFactory factory;
    private final Type approximatedType;
    private final Type boundType;

    protected JavaXType(Type unboundType, TypeEnvironment context, JavaXFactory factory) {
        this.context = context;
        this.factory = factory;
        this.boundType = context.bind(unboundType);
        this.approximatedType = factory.toApproximatingEnvironment(context).bind(unboundType);
    }

    public abstract boolean isArray();

    public abstract boolean isCollection();

    public abstract XClass getElementClass();

    public abstract XClass getClassOrElementClass();

    public abstract Class<? extends Collection> getCollectionClass();

    public abstract XClass getMapKey();

    public abstract XClass getType();

    public boolean isResolved() {
        return TypeUtils.isResolved(this.boundType);
    }

    protected Type approximate() {
        return this.approximatedType;
    }

    protected XClass toXClass(Type type) {
        return this.factory.toXClass(type, this.context);
    }
}

