/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.lang.reflect.Array;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.richfaces.validator.NullValueValidator;

public abstract class UIRichInput
extends UIInput {
    protected void validateValue(FacesContext context, Object newValue) {
        if (this.isValid() && this.isRequired() && UIRichInput.isEmpty(newValue)) {
            super.validateValue(context, newValue);
        }
        UIRichInput.validateInput(context, this, newValue);
    }

    public static void validateInput(FacesContext context, UIInput component, Object newValue) {
        Validator[] validators;
        if (component.isValid() && (validators = component.getValidators()) != null) {
            for (Validator validator : validators) {
                try {
                    if (!(validator instanceof NullValueValidator) && UIRichInput.isEmpty(newValue)) continue;
                    validator.validate(context, (UIComponent)component, newValue);
                }
                catch (ValidatorException ve) {
                    FacesMessage message;
                    component.setValid(false);
                    String validatorMessageString = component.getValidatorMessage();
                    if (null != validatorMessageString) {
                        message = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessageString, validatorMessageString);
                        message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    } else {
                        message = ve.getFacesMessage();
                    }
                    if (message == null) continue;
                    context.addMessage(component.getClientId(context), message);
                }
            }
        }
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String && ((String)value).length() < 1) {
            return true;
        }
        return value.getClass().isArray() ? 0 == Array.getLength(value) : value instanceof List && ((List)value).isEmpty();
    }
}

