package com.jboss.jbds.installer;


import java.util.Iterator;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;

public class UpdatePacksPanel extends IzPanel{

	private static final long serialVersionUID = 1256443616359329170L;

	
	public UpdatePacksPanel(InstallerFrame parent, InstallData idata) {
		super(parent, idata);
		setHidden(true);
	}
	
	public void panelActivate() {
		String group = idata.getVariable("INSTALL_GROUP");
		
		idata.selectedPacks.clear();
        idata.selectedPacks.addAll(idata.availablePacks);
        Iterator iter = idata.selectedPacks.iterator();
        while( iter.hasNext() )
        {
            Pack p = (Pack) iter.next();

            p.revDependencies = null;
            if(!p.installGroups.contains(group))
            {
                iter.remove();
            }
        }
		parent.skipPanel();
	}
	
	public String getSummaryBody()
    {
		String group = idata.getVariable("INSTALL_GROUP");
		String version = idata.getVariable("VERSION");
		StringBuffer buffer = new StringBuffer();
		buffer.append("JBoss Developer Studio "+version+"<br>");
		buffer.append("Eclipse<br>");
		if("jbosseap".equals(group))
			buffer.append("JBoss Enterprise Application Platform<br>");
		
        return buffer.toString();
    }
}
