package com.jboss.jbds.installer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import junit.framework.TestCase;

import com.jboss.jbds.installer.ServerListPanel.ServerListTableModel;
import com.jboss.jbds.installer.bean.ServerBean;
import com.jboss.jbds.installer.bean.ServerListBean;
import com.jboss.jbds.installer.bean.ServerType;

public class ServerListTableModelTest extends TestCase {

	public void testGetValueAt() {
		ServerListBean bean = new ServerListBean();
		bean.setServers(new ArrayList<ServerBean>(ServerListBeanTestData.getTestList()));
		ServerListTableModel model = new ServerListTableModel(bean, CommonTestData.langpack);
		for (ServerBean serBean : bean.getServers()) {
			int index = bean.getServers().indexOf(serBean);
			assertEquals(serBean.getName(), model.getValueAt(index, 0));
			assertEquals(serBean.getType(), model.getValueAt(index, 1));
			assertEquals(serBean.getVersion(), model.getValueAt(index, 2));
			assertEquals(serBean.getLocation(), model.getValueAt(index, 3));			
		}
		ServerBean updateBean = new ServerBean("/home/user/server4","server4",ServerType.EAP,"4.2");
		TestTableModelListener testListener = new TestTableModelListener(model, TableModelEvent.UPDATE,1, 1, TableModelEvent.ALL_COLUMNS);
		model.addTableModelListener(testListener);
		bean.setServers(1, updateBean);
		testListener.assertPassed();
		testListener.reset();
		int index = 1;
		assertEquals(model.getRowCount(), bean.getServers().size());
		assertEquals(updateBean.getName(), model.getValueAt(index, 0));
		assertEquals(updateBean.getType(), model.getValueAt(index, 1));
		assertEquals(updateBean.getVersion(), model.getValueAt(index, 2));
		assertEquals(updateBean.getLocation(), model.getValueAt(index, 3));
		List<ServerBean> newServers = new ArrayList<ServerBean>(Arrays.asList(new ServerBean("/home/user/server5","server5",ServerType.EAP,"4.2")));
		testListener = new TestTableModelListener(model, TableModelEvent.UPDATE, 0, Integer.MAX_VALUE, TableModelEvent.ALL_COLUMNS);
		model.addTableModelListener(testListener);
		bean.setServers(newServers);
		testListener.assertPassed();
		testListener.reset();
		
		bean.remove(0);
		testListener.assertPassed();
		assertEquals(model.getRowCount(),0);
	}
	
	public static class TestTableModelListener implements TableModelListener {

		private TableModel model;
	    protected int type;
	    protected int firstRow;
	    protected int lastRow;
	    protected int column;
	    
	    boolean passed = false;
	    
	    public TestTableModelListener(TableModel model, int type, int firstRow,
				int lastRow, int column) {
			super();
			this.model = model;
			this.type = type;
			this.firstRow = firstRow;
			this.lastRow = lastRow;
			this.column = column;
		}
	    
		public void tableChanged(TableModelEvent e) {
			if(!passed 
					&& e.getSource()==model
					&& e.getType() == type
					&& e.getFirstRow() == firstRow
					&& e.getLastRow() == lastRow 
					&& e.getColumn() == column) {
				passed = true;
			}
		}
		
		public void assertPassed() {
			assertTrue(passed);
		}
		
		public void reset() {
			passed = false;
		}
	}

}
