/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.edi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.ProfileTargetingExpression;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.EDIParser;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.resource.URIResourceLocator;
import org.milyn.xml.SmooksXMLReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIReader
extends EDIParser
implements SmooksXMLReader {
    private static Log logger = LogFactory.getLog(EDIReader.class);
    private static String MAPPING_TABLE_CTX_KEY = EDIReader.class.getName() + "#MAPPING_TABLE_CTX_KEY";
    public static final String MODEL_CONFIG_KEY = "mapping-model";
    private static URIResourceLocator uriMappingLocator = new URIResourceLocator();
    @Config
    private SmooksResourceConfiguration configuration;
    private ExecutionContext executionContext;
    @ConfigParam(name="mapping-model")
    private String modelConfigData;
    @ConfigParam(defaultVal="UTF-8")
    private Charset encoding;
    @ConfigParam(defaultVal="true")
    private Boolean validate;

    public void setExecutionContext(ExecutionContext executionContext) {
        AssertArgument.isNotNull((Object)executionContext, (String)"executionContext");
        this.executionContext = executionContext;
    }

    public void parse(InputSource ediSource) throws IOException, SAXException {
        EdifactModel edi2xmlMappingModel = this.getMappingModel();
        this.setMappingModel(edi2xmlMappingModel);
        this.setValidateValueNodes();
        super.parse(ediSource);
    }

    private void setValidateValueNodes() throws SAXNotSupportedException, SAXNotRecognizedException {
        super.setFeature("http://xml.org/sax/features/validation", this.validate.booleanValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EdifactModel getMappingModel() throws IOException, SAXException {
        EdifactModel edifactModel;
        Hashtable mappings = EDIReader.getMappingTable(this.executionContext.getContext());
        SmooksResourceConfiguration smooksResourceConfiguration = this.configuration;
        synchronized (smooksResourceConfiguration) {
            edifactModel = (EdifactModel)mappings.get(this.configuration);
            if (edifactModel == null) {
                InputStream mappingConfigData = this.getMappingConfigData();
                try {
                    edifactModel = EDIParser.parseMappingModel((Reader)new InputStreamReader(mappingConfigData, this.encoding));
                }
                catch (IOException e) {
                    IOException newE = new IOException("Error parsing EDI mapping model [" + this.configuration.getStringParameter(MODEL_CONFIG_KEY) + "].  Target Profile(s) " + this.getTargetProfiles() + ".");
                    newE.initCause(e);
                    throw newE;
                }
                catch (SAXException e) {
                    throw new SAXException("Error parsing EDI mapping model [" + this.configuration.getStringParameter(MODEL_CONFIG_KEY) + "].  Target Profile(s) " + this.getTargetProfiles() + ".", e);
                }
                catch (EDIConfigurationException e) {
                    throw new SAXException("Error parsing EDI mapping model [" + this.configuration.getStringParameter(MODEL_CONFIG_KEY) + "].  Target Profile(s) " + this.getTargetProfiles() + ".", (Exception)((Object)e));
                }
                mappings.put(this.configuration, edifactModel);
                logger.info((Object)("Parsed, validated and cached EDI mapping model [" + edifactModel.getEdimap().getDescription().getName() + ", Version " + edifactModel.getEdimap().getDescription().getVersion() + "].  Target Profile(s) " + this.getTargetProfiles() + "."));
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)("Found EDI mapping model [" + edifactModel.getEdimap().getDescription().getName() + ", Version " + edifactModel.getEdimap().getDescription().getVersion() + "] in the model cache.  Target Profile(s) " + this.getTargetProfiles() + "."));
            }
        }
        return edifactModel;
    }

    protected static Hashtable getMappingTable(ApplicationContext context) {
        Hashtable mappingModelTable = (Hashtable)context.getAttribute((Object)MAPPING_TABLE_CTX_KEY);
        if (mappingModelTable == null) {
            mappingModelTable = new Hashtable();
            context.setAttribute((Object)MAPPING_TABLE_CTX_KEY, mappingModelTable);
        }
        return mappingModelTable;
    }

    private InputStream getMappingConfigData() {
        InputStream configStream = null;
        try {
            new URI(this.modelConfigData);
            configStream = uriMappingLocator.getResource(this.modelConfigData);
            if (configStream == null) {
                logger.error((Object)("Invalid mapping-model config value '" + this.modelConfigData + "'. Failed to locate resource!"));
            }
        }
        catch (URISyntaxException e) {
            configStream = new ByteArrayInputStream(this.modelConfigData.getBytes());
        }
        catch (IOException e) {
            IllegalStateException state = new IllegalStateException("Invalid EDI mapping model config specified for " + ((Object)((Object)this)).getClass().getName() + ".  Unable to access URI based mapping model [" + this.modelConfigData + "].  Target Profile(s) " + this.getTargetProfiles() + ".");
            state.initCause(e);
            throw state;
        }
        return configStream;
    }

    private List<ProfileTargetingExpression> getTargetProfiles() {
        return Arrays.asList(this.configuration.getProfileTargetingExpressions());
    }
}

